/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.external.PBoxICCOutputProfile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.tools.IDGenerator;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDOutputIntent
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDOutputIntent {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDOutputIntent.class);
    public static final String OUTPUT_INTENT_TYPE = "PDOutputIntent";
    public static final String DEST_PROFILE = "destProfile";
    public static final String DEST_OUTPUT_PROFILE_REF = "DestOutputProfileRef";
    private final String destOutputProfileIndirect;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDOutputIntent(PDOutputIntent simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, OUTPUT_INTENT_TYPE);
        this.destOutputProfileIndirect = this.getDestOutputProfileIndirect(simplePDObject);
        this.document = document;
        this.flavour = flavour;
    }

    private String getDestOutputProfileIndirect(PDOutputIntent intent) {
        COSDictionary dictionary = (COSDictionary)intent.getCOSObject();
        COSBase item = dictionary.getItem(COSName.DEST_OUTPUT_PROFILE);
        return IDGenerator.generateID(item);
    }

    public String getdestOutputProfileIndirect() {
        return this.destOutputProfileIndirect;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "destProfile": {
                return this.getDestProfile();
            }
            case "DestOutputProfileRef": {
                return this.getDestOutputProfileRef();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ICCOutputProfile> getDestProfile() {
        COSBase dict = this.simplePDObject.getCOSObject();
        String subtype = null;
        if (dict instanceof COSDictionary) {
            subtype = ((COSDictionary)dict).getNameAsString(COSName.S);
        }
        try {
            COSStream dest = ((PDOutputIntent)this.simplePDObject).getDestOutputIntent();
            if (dest != null) {
                ArrayList<PBoxICCOutputProfile> profile = new ArrayList<PBoxICCOutputProfile>(1);
                InputStream unfilteredStream = dest.getUnfilteredStream();
                long N = dest.getLong(COSName.N);
                profile.add(new PBoxICCOutputProfile(unfilteredStream, subtype, N != -1L ? Long.valueOf(N) : null));
                return Collections.unmodifiableList(profile);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Can not read dest output profile. " + e.getMessage()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<CosObject> getDestOutputProfileRef() {
        COSDictionary dict = (COSDictionary)this.simplePDObject.getCOSObject();
        COSBase ref = dict.getDictionaryObject(COSName.getPDFName((String)DEST_OUTPUT_PROFILE_REF));
        CosObject value = PBCosObject.getFromValue(ref, this.document, this.flavour);
        if (value != null) {
            ArrayList<CosObject> list = new ArrayList<CosObject>(1);
            list.add(value);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

