/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.FontBoxFont;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.external.PBoxFontProgram;
import org.verapdf.model.impl.pb.external.PBoxTrueTypeFontProgram;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.pdlayer.PDFont;
import org.verapdf.model.tools.IDGenerator;

public abstract class PBoxPDFont
extends PBoxPDResources
implements PDFont {
    public static final String FONT_FILE = "fontFile";
    public static final String BASE_FONT = "BaseFont";
    protected final RenderingMode renderingMode;
    private final String id;

    protected PBoxPDFont(PDFontLike font, RenderingMode renderingMode, String type) {
        super(font, type);
        this.renderingMode = renderingMode;
        this.id = IDGenerator.generateID(font);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getType() {
        String type = null;
        if (this.pdFontLike instanceof org.apache.pdfbox.pdmodel.font.PDFont) {
            type = ((org.apache.pdfbox.pdmodel.font.PDFont)this.pdFontLike).getType();
        } else if (this.pdFontLike instanceof PDCIDFont) {
            type = ((PDCIDFont)this.pdFontLike).getCOSObject().getNameAsString(COSName.TYPE);
        }
        return type;
    }

    public String getfontName() {
        return this.pdFontLike.getName();
    }

    public String getSubtype() {
        String subtype = null;
        if (this.pdFontLike instanceof org.apache.pdfbox.pdmodel.font.PDFont) {
            subtype = ((org.apache.pdfbox.pdmodel.font.PDFont)this.pdFontLike).getSubType();
        } else if (this.pdFontLike instanceof PDCIDFont) {
            subtype = ((PDCIDFont)this.pdFontLike).getCOSObject().getNameAsString(COSName.SUBTYPE);
        }
        return subtype;
    }

    public Boolean getisSymbolic() {
        PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
        return fontDescriptor.isSymbolic();
    }

    public Long getrenderingMode() {
        return this.renderingMode.intValue();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "fontFile": {
                return this.getFontFile();
            }
            case "BaseFont": {
                return this.getBaseFont();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<FontProgram> getFontFile() {
        if (!this.getSubtype().equals("Type3") && this.pdFontLike.isEmbedded()) {
            if (this.getSubtype().equals("TrueType")) {
                PBoxTrueTypeFontProgram trueTypeFontProgram = new PBoxTrueTypeFontProgram((FontBoxFont)((PDTrueTypeFont)this.pdFontLike).getTrueTypeFont(), this.getisSymbolic());
                return this.getFontProgramList(trueTypeFontProgram);
            }
            PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
            PDStream fontFile = this.getSubtype().equals("Type1") ? (this.pdFontLike instanceof PDType1CFont ? fontDescriptor.getFontFile3() : fontDescriptor.getFontFile()) : (this.getSubtype().equals("CIDFontType2") ? fontDescriptor.getFontFile2() : fontDescriptor.getFontFile3());
            if (fontFile != null) {
                return this.getFontProgramList(new PBoxFontProgram(fontFile));
            }
        }
        return Collections.emptyList();
    }

    private List<FontProgram> getFontProgramList(FontProgram fontProgram) {
        ArrayList<FontProgram> list = new ArrayList<FontProgram>(1);
        list.add(fontProgram);
        return Collections.unmodifiableList(list);
    }

    private List<CosUnicodeName> getBaseFont() {
        String name = this.pdFontLike.getName();
        if (name != null) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(1);
            list.add(new PBCosUnicodeName(COSName.getPDFName((String)name)));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

