/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.colors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.impl.pb.external.PBoxICCInputProfile;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.model.pdlayer.PDICCBased;

public class PBoxPDICCBased
extends PBoxPDColorSpace
implements PDICCBased {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDICCBased.class);
    public static final String ICC_BASED_TYPE = "PDICCBased";
    public static final String ICC_PROFILE = "iccProfile";

    public PBoxPDICCBased(org.apache.pdfbox.pdmodel.graphics.color.PDICCBased simplePDObject) {
        super((PDColorSpace)simplePDObject, ICC_BASED_TYPE);
    }

    protected PBoxPDICCBased(org.apache.pdfbox.pdmodel.graphics.color.PDICCBased simplePDObject, String type) {
        super((PDColorSpace)simplePDObject, type);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (ICC_PROFILE.equals(link)) {
            return this.getICCProfile();
        }
        return super.getLinkedObjects(link);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ICCInputProfile> getICCProfile() {
        try {
            PDStream pdStream = ((org.apache.pdfbox.pdmodel.graphics.color.PDICCBased)this.simplePDObject).getPDStream();
            try (InputStream stream = pdStream.createInputStream();){
                Long N = pdStream.getStream().getLong(COSName.N);
                if (stream == null) return Collections.emptyList();
                if (stream.available() <= 0) return Collections.emptyList();
                ArrayList<PBoxICCInputProfile> inputProfile = new ArrayList<PBoxICCInputProfile>(1);
                N = N != -1L ? N : null;
                inputProfile.add(new PBoxICCInputProfile(stream, N));
                List<ICCInputProfile> list = Collections.unmodifiableList(inputProfile);
                return list;
            }
        }
        catch (IOException e) {
            LOGGER.debug((java.lang.Object)"Can not get input profile from ICCBased. ", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

