/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.signatures;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.SignatureParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.impl.pb.external.PBoxPKCSDataObject;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.signatures.PBoxPDSigRef;
import org.verapdf.model.pdlayer.PDSigRef;

public class PBoxPDSignature
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDSignature {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDSignature.class);
    public static final String SIGNATURE_TYPE = "PDSignature";
    public static final String CONTENTS = "Contents";
    public static final String REFERENCE = "Reference";
    protected static byte[] contents;
    protected long signatureOffset;

    public PBoxPDSignature(PDSignature pdSignature, PDDocument document, COSObject signatureReference) {
        super((COSObjectable)pdSignature, SIGNATURE_TYPE);
        this.document = document;
        COSObjectKey key = new COSObjectKey(signatureReference);
        this.signatureOffset = (Long)this.document.getDocument().getXrefTable().get(key);
        contents = ((PDSignature)this.simplePDObject).getContents();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Contents": {
                return PBoxPDSignature.getContents();
            }
            case "Reference": {
                return this.getSigRefs();
            }
        }
        return super.getLinkedObjects(link);
    }

    public Boolean getdoesByteRangeCoverEntireDocument() {
        try {
            SignatureParser parser = new SignatureParser(this.document.getPdfSource(), this.document.getDocument());
            long[] actualByteRange = parser.getByteRangeBySignatureOffset(this.signatureOffset);
            int[] byteRange = ((PDSignature)this.simplePDObject).getByteRange();
            for (int i = 0; i < 3; ++i) {
                if ((long)byteRange[i] == actualByteRange[i]) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException ex) {
            LOGGER.debug((Object)"Can't create parser to process digital signature", (Throwable)ex);
            return Boolean.FALSE;
        }
    }

    private static List<PKCSDataObject> getContents() {
        if (contents != null) {
            ArrayList<PBoxPKCSDataObject> list = new ArrayList<PBoxPKCSDataObject>(1);
            list.add(new PBoxPKCSDataObject(new COSString(contents)));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDSigRef> getSigRefs() {
        COSArray reference = (COSArray)((PDSignature)this.simplePDObject).getCOSObject().getDictionaryObject(REFERENCE);
        if (reference == null || reference.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PBoxPDSigRef> list = new ArrayList<PBoxPDSigRef>();
        for (COSBase sigRef : reference) {
            list.add(new PBoxPDSigRef((COSDictionary)sigRef, this.document));
        }
        return Collections.unmodifiableList(list);
    }
}

