/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.pb.PBFeatureParser;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.impl.pb.model.PDFDocumentImpl;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class ModelParser
implements PDFAParser {
    private static final ReleaseDetails pdfBoxReleaseDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/pdfbox-parser.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#pdfbox");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"PDFBox Parser", (String)pdfBoxReleaseDetails.getVersion(), (String)"veraPDF PDFBox based model parser.");
    private static final Logger logger = Logger.getLogger(ModelParser.class);
    private PDDocument document;
    private final PDFAFlavour flavour;

    private ModelParser(InputStream docStream, PDFAFlavour flavour) throws IOException {
        this.document = PDDocument.load((InputStream)docStream, (boolean)false, (boolean)true);
        this.flavour = flavour == PDFAFlavour.NO_FLAVOUR ? ModelParser.obtainFlavour(this.document) : flavour;
    }

    public static ModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        try {
            ModelParser.cleanUp();
            return new ModelParser(toLoad, flavour);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException excep) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)excep);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFAFlavour obtainFlavour(PDDocument document) {
        PDFAFlavour defaultFlavour = Foundries.defaultInstance().defaultFlavour();
        if (document == null) return defaultFlavour;
        if (document.getDocumentCatalog() == null) {
            return defaultFlavour;
        }
        PDMetadata metadata = document.getDocumentCatalog().getMetadata();
        if (metadata == null) {
            return defaultFlavour;
        }
        try (InputStream is = metadata.exportXMPMetadata();){
            PDFAFlavour pdfaFlavour;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
            Integer identificationPart = veraPDFMeta.getIdentificationPart();
            String identificationConformance = veraPDFMeta.getIdentificationConformance();
            PDFAFlavour pDFAFlavour = pdfaFlavour = PDFAFlavour.byFlavourId((String)(identificationPart + identificationConformance));
            return pDFAFlavour;
        }
        catch (XMPException | IOException e) {
            logger.error((java.lang.Object)e);
            return defaultFlavour;
        }
    }

    private static void cleanUp() {
        StaticContainers.clearAllContainers();
    }

    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public Object getRoot() {
        return new PBCosDocument(this.document, this.flavour);
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return PBFeatureParser.getFeaturesCollection((PDDocument)this.document, (FeatureExtractorConfig)config);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return PBFeatureParser.getFeaturesCollection((PDDocument)this.document, extractors, (FeatureExtractorConfig)config);
    }

    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            logger.error((java.lang.Object)"Problems with document close.", (Throwable)e);
        }
    }
}

