/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.font.PBoxPDFont;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDCIDFont
extends PBoxPDFont
implements org.verapdf.model.pdlayer.PDCIDFont {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDCIDFont.class);
    private final PDDocument pdDocument;
    private final PDFAFlavour flavour;
    public static final String CID_FONT_TYPE = "PDCIDFont";
    public static final String CID_SET = "CIDSet";
    public static final String IDENTITY = "Identity";
    public static final String CUSTOM = "Custom";

    public PBoxPDCIDFont(PDFontLike font, RenderingMode renderingMode, PDDocument document, PDFAFlavour flavour) {
        super(font, renderingMode, CID_FONT_TYPE);
        this.pdDocument = document;
        this.flavour = flavour;
    }

    public String getCIDToGIDMap() {
        if (this.pdFontLike instanceof PDCIDFontType2) {
            COSBase map = ((PDCIDFontType2)this.pdFontLike).getCOSObject().getDictionaryObject(COSName.CID_TO_GID_MAP);
            if (map instanceof COSStream) {
                return CUSTOM;
            }
            if (map instanceof COSName && IDENTITY.equals(((COSName)map).getName())) {
                return IDENTITY;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean getcidSetListsAllGlyphs() {
        PDStream cidSet = this.getCIDSetStream();
        if (cidSet == null) {
            return Boolean.TRUE;
        }
        try {
            InputStream stream = ((COSStream)cidSet.getCOSObject()).getUnfilteredStream();
            int length = cidSet.getLength();
            byte[] cidSetBytes = PBoxPDCIDFont.getCIDsFromCIDSet(stream, length);
            BitSet bitSet = PBoxPDCIDFont.toBitSetBigEndian(cidSetBytes);
            PDCIDFont cidFont = (PDCIDFont)this.pdFontLike;
            for (int i = 1; i < bitSet.size(); ++i) {
                if (!bitSet.get(i) || cidFont.hasGlyph(i)) continue;
                return Boolean.FALSE;
            }
            if (this.flavour.equals((Object)PDFAFlavour.PDFA_1_A)) {
                if (this.flavour.equals((Object)PDFAFlavour.PDFA_1_B)) return Boolean.TRUE;
            }
            if (cidFont instanceof PDCIDFontType0) {
                CFFFont cffFont = ((PDCIDFontType0)cidFont).getCFFFont();
                if (cffFont == null) {
                    return Boolean.FALSE;
                }
                if (bitSet.cardinality() >= cffFont.getNumCharStrings()) return Boolean.TRUE;
                return Boolean.FALSE;
            }
            if (!(cidFont instanceof PDCIDFontType2)) return Boolean.TRUE;
            try (TrueTypeFont trueTypeFont = ((PDCIDFontType2)cidFont).getTrueTypeFont();){
                if (bitSet.cardinality() >= trueTypeFont.getNumberOfGlyphs()) return Boolean.TRUE;
                Boolean bl = Boolean.FALSE;
                return bl;
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Error while parsing embedded font program. " + e.getMessage()), (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        if (CID_SET.equals(link)) {
            return this.getCIDSet();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosStream> getCIDSet() {
        PDStream cidSet = this.getCIDSetStream();
        if (cidSet != null) {
            ArrayList<PBCosStream> res = new ArrayList<PBCosStream>(1);
            res.add(new PBCosStream(cidSet.getStream(), this.pdDocument, this.flavour));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private PDStream getCIDSetStream() {
        PDFontDescriptor fontDescriptor = this.pdFontLike.getFontDescriptor();
        if (fontDescriptor != null) {
            PDStream cidSet = fontDescriptor.getCIDSet();
            return cidSet;
        }
        return null;
    }

    private static byte[] getCIDsFromCIDSet(InputStream cidSet, int length) throws IOException {
        byte[] cidSetBytes = new byte[length];
        if (cidSet.read(cidSetBytes) != length) {
            LOGGER.debug((Object)"Did not read necessary number of cid set bytes");
        }
        return cidSetBytes;
    }

    private static BitSet toBitSetBigEndian(byte[] source) {
        BitSet bitSet = new BitSet(source.length * 8);
        int i = 0;
        for (int j = 0; j < source.length; ++j) {
            int b = source[j] >= 0 ? source[j] : 256 + source[j];
            for (int k = 0; k < 8; ++k) {
                bitSet.set(i++, (b & 0x80) != 0);
                b <<= 1;
            }
        }
        return bitSet;
    }
}

