/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.impl.pb.external.PBoxICCOutputProfile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.tools.IDGenerator;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDOutputIntent
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDOutputIntent {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDOutputIntent.class);
    public static final String OUTPUT_INTENT_TYPE = "PDOutputIntent";
    public static final String DEST_PROFILE = "destProfile";
    private final String destOutputProfileIndirect;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDOutputIntent(PDOutputIntent simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, OUTPUT_INTENT_TYPE);
        this.destOutputProfileIndirect = PBoxPDOutputIntent.getDestOutputProfileIndirect(simplePDObject);
        this.document = document;
        this.flavour = flavour;
    }

    private static String getDestOutputProfileIndirect(PDOutputIntent intent) {
        COSDictionary dictionary = (COSDictionary)intent.getCOSObject();
        COSBase item = dictionary.getItem(COSName.DEST_OUTPUT_PROFILE);
        return IDGenerator.generateID(item);
    }

    public String getdestOutputProfileIndirect() {
        return this.destOutputProfileIndirect;
    }

    public String getS() {
        COSBase dict = this.simplePDObject.getCOSObject();
        if (dict instanceof COSDictionary) {
            return ((COSDictionary)dict).getNameAsString(COSName.S);
        }
        return null;
    }

    public String getOutputConditionIdentifier() {
        PDOutputIntent outInt = (PDOutputIntent)this.simplePDObject;
        return outInt.getOutputConditionIdentifier();
    }

    public Boolean getcontainsDestOutputProfileRef() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName((String)"DestOutputProfileRef"));
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "destProfile": {
                return this.getDestProfile();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ICCOutputProfile> getDestProfile() {
        try {
            COSStream dest = ((PDOutputIntent)this.simplePDObject).getDestOutputIntent();
            if (dest != null) {
                return PBoxPDOutputIntent.getDestProfilesFromStream(dest, this.getS());
            }
        }
        catch (IOException e) {
            LOGGER.debug((java.lang.Object)("Can not read dest output profile. " + e.getMessage()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static List<ICCOutputProfile> getDestProfilesFromStream(COSStream destStream, String subType) throws IOException {
        ArrayList<PBoxICCOutputProfile> profile = new ArrayList<PBoxICCOutputProfile>(1);
        profile.add(new PBoxICCOutputProfile(destStream, subType));
        return Collections.unmodifiableList(profile);
    }
}

