/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.ModelParser;
import org.verapdf.model.external.EmbeddedFile;
import org.verapdf.model.impl.pb.external.PBoxExternal;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;

public class PBoxEmbeddedFile
extends PBoxExternal
implements EmbeddedFile {
    private static final Logger LOGGER = Logger.getLogger(PBoxEmbeddedFile.class);
    public static final String EMBEDDED_FILE_TYPE = "EmbeddedFile";
    private final COSStream stream;

    public PBoxEmbeddedFile(COSBase baseStream) {
        super(EMBEDDED_FILE_TYPE);
        this.stream = baseStream instanceof COSStream ? (COSStream)baseStream : null;
    }

    public String getSubtype() {
        if (this.stream != null) {
            return this.stream.getNameAsString(COSName.SUBTYPE);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean getisValidPDFA12() {
        if (this.stream == null) return Boolean.TRUE;
        try {
            InputStream unfilteredStream = this.stream.getUnfilteredStream();
            unfilteredStream.mark(Integer.MAX_VALUE);
            try (ModelParser parser1b = ModelParser.createModelWithFlavour(unfilteredStream, PDFAFlavour.PDFA_1_B);){
                PDFAValidator validator1b = ValidatorFactory.createValidator((PDFAFlavour)PDFAFlavour.PDFA_1_B, (boolean)false, (int)1);
                ValidationResult result1b = validator1b.validate((PDFAParser)parser1b);
                if (result1b.isCompliant()) {
                    Boolean bl2 = Boolean.TRUE;
                    return bl2;
                }
            }
            unfilteredStream.reset();
            try (ModelParser parser2b = ModelParser.createModelWithFlavour(unfilteredStream, PDFAFlavour.PDFA_2_B);){
                PDFAValidator validator2b = ValidatorFactory.createValidator((PDFAFlavour)PDFAFlavour.PDFA_2_B, (boolean)false, (int)1);
                ValidationResult result2b = validator2b.validate((PDFAParser)parser2b);
                Boolean bl = result2b.isCompliant();
                return bl;
            }
        }
        catch (Throwable e) {
            LOGGER.debug((Object)"Exception during validation of embedded file", e);
            return Boolean.FALSE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean getisValidPDFA124() {
        if (this.stream == null) return Boolean.TRUE;
        try {
            InputStream unfilteredStream = this.stream.getUnfilteredStream();
            unfilteredStream.mark(Integer.MAX_VALUE);
            try (ModelParser parser1b = ModelParser.createModelWithFlavour(unfilteredStream, PDFAFlavour.PDFA_1_B);){
                PDFAValidator validator1b = ValidatorFactory.createValidator((PDFAFlavour)PDFAFlavour.PDFA_1_B, (boolean)false, (int)1);
                ValidationResult result1b = validator1b.validate((PDFAParser)parser1b);
                if (result1b.isCompliant()) {
                    Boolean bl3 = Boolean.TRUE;
                    return bl3;
                }
            }
            unfilteredStream.reset();
            try (ModelParser parser2b = ModelParser.createModelWithFlavour(unfilteredStream, PDFAFlavour.PDFA_2_B);){
                PDFAValidator validator2b = ValidatorFactory.createValidator((PDFAFlavour)PDFAFlavour.PDFA_2_B, (boolean)false, (int)1);
                ValidationResult result2b = validator2b.validate((PDFAParser)parser2b);
                if (result2b.isCompliant()) {
                    Boolean bl2 = Boolean.TRUE;
                    return bl2;
                }
            }
            unfilteredStream.reset();
            try (ModelParser parser4 = ModelParser.createModelWithFlavour(unfilteredStream, PDFAFlavour.PDFA_4);){
                PDFAValidator validator4 = ValidatorFactory.createValidator((PDFAFlavour)PDFAFlavour.PDFA_4, (boolean)false, (int)1);
                ValidationResult result4 = validator4.validate((PDFAParser)parser4);
                Boolean bl = result4.isCompliant();
                return bl;
            }
        }
        catch (Throwable e) {
            LOGGER.debug((Object)"Exception during validation of embedded file", e);
            return Boolean.FALSE;
        }
    }
}

