/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDParentTreeValue;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.impl.pb.cos.PBCosBM;
import org.verapdf.model.impl.pb.cos.PBCosLang;
import org.verapdf.model.impl.pb.cos.PBCosNumber;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDAction;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDAnnotationAdditionalActions;
import org.verapdf.model.impl.pb.pd.annotations.PBoxPD3DAnnot;
import org.verapdf.model.impl.pb.pd.annotations.PBoxPDLinkAnnot;
import org.verapdf.model.impl.pb.pd.annotations.PBoxPDPrinterMarkAnnot;
import org.verapdf.model.impl.pb.pd.annotations.PBoxPDTrapNetAnnot;
import org.verapdf.model.impl.pb.pd.annotations.PBoxPDWidgetAnnot;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDAdditionalActions;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDAnnot
extends PBoxPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final String LANG = "Lang";
    public static final String LINK = "Link";
    public static final String PRINTER_MARK = "PrinterMark";
    public static final String WIDGET = "Widget";
    public static final String TRAP_NET = "TrapNet";
    public static final String TYPE_3D = "3D";
    public static final String BM = "BM";
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private final PDResources pageResources;
    private final boolean isFKeyPresent;
    private final String subtype;
    private final String ap;
    private final int annotationFlag;
    private final Double ca;
    private final String nType;
    private final String ft;
    private final Double width;
    private final Double height;
    private final PDDocument document;
    private final PDFAFlavour flavour;
    private final PDPage pdPage;
    private List<org.verapdf.model.pdlayer.PDContentStream> appearance = null;
    private List<CosBM> blendMode = null;
    private boolean containsTransparency = false;

    public PBoxPDAnnot(PDAnnotation annot, PDResources pageResources, PDDocument document, PDFAFlavour flavour, String type, PDPage pdPage) {
        super((COSObjectable)annot, type);
        this.pageResources = pageResources;
        this.subtype = annot.getSubtype();
        this.ap = PBoxPDAnnot.getAP(annot);
        COSDictionary annotDict = annot.getCOSObject();
        this.isFKeyPresent = annotDict.containsKey(COSName.F);
        this.annotationFlag = annot.getAnnotationFlags();
        this.ca = PBoxPDAnnot.getCA(annot);
        this.nType = PBoxPDAnnot.getN_type(annot);
        this.ft = PBoxPDAnnot.getFT(annot);
        this.width = PBoxPDAnnot.getWidth(annot);
        this.height = PBoxPDAnnot.getHeight(annot);
        this.document = document;
        this.flavour = flavour;
        this.pdPage = pdPage;
    }

    public PBoxPDAnnot(PDAnnotation annot, PDResources pageResources, PDDocument document, PDFAFlavour flavour, PDPage pdPage) {
        this(annot, pageResources, document, flavour, ANNOTATION_TYPE, pdPage);
    }

    private static String getAP(PDAnnotation annot) {
        COSBase apLocal = annot.getCOSObject().getDictionaryObject(COSName.AP);
        if (apLocal != null && apLocal instanceof COSDictionary) {
            StringBuilder result = new StringBuilder();
            for (COSName key : ((COSDictionary)apLocal).keySet()) {
                result.append(key.getName());
                result.append(' ');
            }
            return result.length() <= 0 ? result.toString() : result.substring(0, result.length() - 1);
        }
        return null;
    }

    private static Double getCA(PDAnnotation annot) {
        COSBase caLocal = annot.getCOSObject().getDictionaryObject(COSName.CA);
        return !(caLocal instanceof COSNumber) ? null : Double.valueOf(((COSNumber)caLocal).doubleValue());
    }

    private static String getN_type(PDAnnotation annot) {
        PDAppearanceDictionary appearanceDictionary = annot.getAppearance();
        if (appearanceDictionary != null) {
            PDAppearanceEntry normalAppearance = appearanceDictionary.getNormalAppearance();
            if (normalAppearance == null) {
                return null;
            }
            if (normalAppearance.isSubDictionary()) {
                return DICT;
            }
            return STREAM;
        }
        return null;
    }

    private static String getFT(PDAnnotation annot) {
        HashSet<COSObjectKey> visitedKeys = new HashSet<COSObjectKey>();
        COSDictionary curr = annot.getCOSObject();
        while (curr instanceof COSDictionary) {
            COSDictionary currDict = curr;
            COSObjectKey key = currDict.getKey();
            if (key != null) {
                if (visitedKeys.contains(key)) {
                    return null;
                }
                visitedKeys.add(key);
            }
            if (currDict.containsKey(COSName.FT)) {
                return currDict.getNameAsString(COSName.FT);
            }
            curr = currDict.getItem(COSName.PARENT);
            if (!(curr instanceof COSObject)) continue;
            curr = ((COSObject)curr).getObject();
        }
        return null;
    }

    private static Double getWidth(PDAnnotation annot) {
        return PBoxPDAnnot.getDifference(annot, 0);
    }

    private static Double getHeight(PDAnnotation annot) {
        return PBoxPDAnnot.getDifference(annot, 1);
    }

    private static Double getDifference(PDAnnotation annot, int shift) {
        COSBase array = annot.getCOSObject().getDictionaryObject(COSName.RECT);
        if (array instanceof COSArray && ((COSArray)array).size() == 4) {
            COSBase less = ((COSArray)array).getObject(shift);
            COSBase great = ((COSArray)array).getObject(2 + shift);
            if (less instanceof COSNumber && great instanceof COSNumber) {
                return ((COSNumber)great).doubleValue() - ((COSNumber)less).doubleValue();
            }
        }
        return null;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getAP() {
        return this.ap;
    }

    public Long getF() {
        return this.isFKeyPresent ? Long.valueOf(this.annotationFlag) : null;
    }

    public Double getCA() {
        return this.ca;
    }

    public String getN_type() {
        return this.nType;
    }

    public String getFT() {
        return this.ft;
    }

    public Double getwidth() {
        return this.width;
    }

    public Double getheight() {
        return this.height;
    }

    public Boolean getcontainsAA() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.AA);
    }

    public String getstructParentType() {
        PDStructureTreeRoot structTreeRoot = this.document.getDocumentCatalog().getStructureTreeRoot();
        int structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null) {
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSBase structureElement = null;
            try {
                PDParentTreeValue treeValue = (PDParentTreeValue)parentTreeRoot.getValue(Integer.valueOf(structParent));
                if (treeValue != null) {
                    structureElement = treeValue.getCOSObject();
                }
            }
            catch (IOException var6) {
                return null;
            }
            if (structureElement != null && structureElement instanceof COSDictionary) {
                return ((COSDictionary)structureElement).getNameAsString(COSName.S);
            }
        }
        return null;
    }

    private List<CosLang> getLang() {
        PDStructureTreeRoot structTreeRoot = this.document.getDocumentCatalog().getStructureTreeRoot();
        int structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != 0) {
            String lang;
            COSBase structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            try {
                PDParentTreeValue treeValue = parentTreeRoot == null ? null : (PDParentTreeValue)parentTreeRoot.getValue(Integer.valueOf(structParent));
                structureElement = treeValue == null ? null : treeValue.getCOSObject();
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
            if (structureElement instanceof COSDictionary && (lang = ((COSDictionary)structureElement).getNameAsString(COSName.LANG)) != null) {
                ArrayList<PBCosLang> list = new ArrayList<PBCosLang>(1);
                list.add(new PBCosLang(new COSString(lang)));
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    public String getContents() {
        return ((PDAnnotation)this.simplePDObject).getContents();
    }

    public String getAlt() {
        PDStructureTreeRoot structTreeRoot = this.document.getDocumentCatalog().getStructureTreeRoot();
        int structParent = ((PDAnnotation)this.simplePDObject).getStructParent();
        if (structTreeRoot != null && structParent != 0) {
            COSBase structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            try {
                PDParentTreeValue treeValue = parentTreeRoot == null ? null : (PDParentTreeValue)parentTreeRoot.getValue(Integer.valueOf(structParent));
                structureElement = treeValue == null ? null : treeValue.getCOSObject();
            }
            catch (IOException e) {
                return null;
            }
            if (structureElement instanceof COSDictionary) {
                return ((COSDictionary)structureElement).getNameAsString(COSName.ALT);
            }
        }
        return null;
    }

    public Boolean getisOutsideCropBox() {
        PDRectangle cropBox = this.pdPage.getCropBox();
        PDRectangle rectangle = ((PDAnnotation)this.simplePDObject).getRectangle();
        if (rectangle != null) {
            return cropBox.getLowerLeftY() >= rectangle.getUpperRightY() || cropBox.getLowerLeftX() >= rectangle.getUpperRightX() || cropBox.getUpperRightY() <= rectangle.getLowerLeftY() || cropBox.getUpperRightX() <= rectangle.getLowerLeftX();
        }
        return null;
    }

    public Boolean getcontainsA() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.A);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "IC": {
                return this.getIC();
            }
            case "C": {
                return this.getC();
            }
            case "appearance": {
                return this.getAppearance();
            }
            case "Lang": {
                return this.getLang();
            }
            case "BM": {
                return this.getBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosBM> getBM() {
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.blendMode;
    }

    private List<CosBM> parseBM() {
        COSBase BM = ((COSDictionary)this.simplePDObject.getCOSObject()).getDictionaryObject(COSName.BM);
        if (BM == null || this.flavour == null || this.flavour.getPart() != PDFAFlavour.Specification.ISO_19005_4) {
            return Collections.emptyList();
        }
        if (BM instanceof COSName) {
            this.containsTransparency = true;
            ArrayList<PBCosBM> list = new ArrayList<PBCosBM>(1);
            list.add(new PBCosBM((COSName)BM));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected List<PDAdditionalActions> getAdditionalActions() {
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AA);
        if (actionDictionary instanceof COSDictionary && ((COSDictionary)actionDictionary).size() != 0) {
            ArrayList<PBoxPDAnnotationAdditionalActions> actions = new ArrayList<PBoxPDAnnotationAdditionalActions>(1);
            PDAnnotationAdditionalActions additionalActions = new PDAnnotationAdditionalActions((COSDictionary)actionDictionary);
            actions.add(new PBoxPDAnnotationAdditionalActions((COSObjectable)additionalActions));
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDAction> getA() {
        org.apache.pdfbox.pdmodel.interactive.action.PDAction action;
        PDAction result;
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.A);
        if (actionDictionary instanceof COSDictionary && (result = PBoxPDAction.getAction(action = PDActionFactory.createAction((COSDictionary)((COSDictionary)actionDictionary)))) != null) {
            ArrayList<PDAction> actions = new ArrayList<PDAction>(1);
            actions.add(result);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getIC() {
        return this.getNumbersFromArray(COSName.IC);
    }

    private List<CosNumber> getC() {
        return this.getNumbersFromArray(COSName.C);
    }

    private List<CosNumber> getNumbersFromArray(COSName arrayName) {
        COSBase colorArray = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(arrayName);
        if (colorArray instanceof COSArray) {
            ArrayList<PBCosNumber> color = new ArrayList<PBCosNumber>(((COSArray)colorArray).size());
            for (COSBase colorValue : (COSArray)colorArray) {
                if (!(colorValue instanceof COSNumber)) continue;
                color.add(PBCosNumber.fromPDFBoxNumber(colorValue));
            }
            return Collections.unmodifiableList(color);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDContentStream> getAppearance() {
        if (this.appearance == null) {
            this.parseAppearance();
        }
        return this.appearance;
    }

    boolean isContainsTransparency() {
        if (this.appearance == null) {
            this.parseAppearance();
        }
        if (this.blendMode == null) {
            this.blendMode = this.parseBM();
        }
        return this.containsTransparency;
    }

    private void parseAppearance() {
        PDAppearanceDictionary appearanceDictionary = ((PDAnnotation)this.simplePDObject).getAppearance();
        if (appearanceDictionary != null) {
            COSDictionary dictionary = appearanceDictionary.getCOSObject();
            COSBase normalAppearanceBase = dictionary.getDictionaryObject(COSName.N);
            COSBase downAppearanceBase = dictionary.getDictionaryObject(COSName.D);
            COSBase rolloverAppearanceBase = dictionary.getDictionaryObject(COSName.R);
            if (normalAppearanceBase != null || downAppearanceBase != null || rolloverAppearanceBase != null) {
                ArrayList<org.verapdf.model.pdlayer.PDContentStream> appearances = new ArrayList<org.verapdf.model.pdlayer.PDContentStream>();
                this.addContentStreamsFromAppearanceEntry(normalAppearanceBase, appearances);
                this.addContentStreamsFromAppearanceEntry(downAppearanceBase, appearances);
                this.addContentStreamsFromAppearanceEntry(rolloverAppearanceBase, appearances);
                this.appearance = Collections.unmodifiableList(appearances);
            } else {
                this.appearance = Collections.emptyList();
            }
        } else {
            this.appearance = Collections.emptyList();
        }
    }

    private void addContentStreamsFromAppearanceEntry(COSBase appearanceEntry, List<org.verapdf.model.pdlayer.PDContentStream> appearances) {
        if (appearanceEntry != null) {
            PDAppearanceEntry newAppearance = new PDAppearanceEntry(appearanceEntry);
            if (newAppearance.isStream()) {
                this.addAppearance(appearances, newAppearance.getAppearanceStream());
            } else {
                Map subDictionary = newAppearance.getSubDictionary();
                for (PDAppearanceStream stream : subDictionary.values()) {
                    this.addAppearance(appearances, stream);
                }
            }
        }
    }

    private void addAppearance(List<org.verapdf.model.pdlayer.PDContentStream> list, PDAppearanceStream toAdd) {
        if (toAdd != null) {
            PDInheritableResources resources = PDInheritableResources.getInstance(this.pageResources, toAdd.getResources());
            PBoxPDContentStream stream = new PBoxPDContentStream((PDContentStream)toAdd, resources, this.document, this.flavour);
            this.containsTransparency |= stream.isContainsTransparency();
            PDGroup group = toAdd.getGroup();
            this.containsTransparency |= group != null && COSName.TRANSPARENCY.equals((Object)group.getSubType());
            list.add(stream);
        }
    }

    public static PBoxPDAnnot createAnnot(PDAnnotation annot, PDResources pageResources, PDDocument document, PDFAFlavour flavour, PDPage pdPage) {
        String subtype = annot.getSubtype();
        if (subtype == null) {
            return new PBoxPDAnnot(annot, pageResources, document, flavour, pdPage);
        }
        switch (subtype) {
            case "Widget": {
                return new PBoxPDWidgetAnnot(annot, pageResources, document, flavour, pdPage);
            }
            case "3D": {
                return new PBoxPD3DAnnot(annot, pageResources, document, flavour, pdPage);
            }
            case "TrapNet": {
                return new PBoxPDTrapNetAnnot(annot, pageResources, document, flavour, pdPage);
            }
            case "Link": {
                return new PBoxPDLinkAnnot(annot, pageResources, document, flavour, pdPage);
            }
            case "PrinterMark": {
                return new PBoxPDPrinterMarkAnnot(annot, pageResources, document, flavour, pdPage);
            }
        }
        return new PBoxPDAnnot(annot, pageResources, document, flavour, pdPage);
    }
}

