/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PD3DStream;

public class PBoxPD3DStream
extends PBoxPDObject
implements PD3DStream {
    public static final String STREAM_3D_TYPE = "PD3DStream";
    public static final String COLOR_SPACE = "colorSpace";
    private static final Logger LOGGER = Logger.getLogger(PBoxPD3DStream.class.getCanonicalName());
    private final PDResources resources;

    public PBoxPD3DStream(COSStream stream, PDResources resources) {
        super((COSObjectable)stream, STREAM_3D_TYPE);
        this.resources = resources;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "colorSpace": {
                return this.getColorSpace();
            }
        }
        return super.getLinkedObjects(link);
    }

    public String getSubtype() {
        COSName subtype = ((COSStream)this.simplePDObject).getCOSName(COSName.SUBTYPE);
        return subtype == null ? null : subtype.getName();
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace() {
        try {
            COSBase rawColorSpace = ((COSStream)this.simplePDObject).getItem(COSName.COLORSPACE);
            COSName colorSpaceName = null;
            PDColorSpace colorSpace = null;
            if (rawColorSpace != null) {
                if (rawColorSpace instanceof COSName) {
                    colorSpaceName = (COSName)rawColorSpace;
                } else if (rawColorSpace instanceof COSArray) {
                    COSArray array = (COSArray)rawColorSpace;
                    if (array.size() == 1 && array.get(0) instanceof COSName) {
                        colorSpaceName = (COSName)array.get(0);
                    } else {
                        try {
                            colorSpace = PDColorSpace.create((COSBase)rawColorSpace);
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "There is no colorSpace by rawColorSpace");
                        }
                    }
                }
            }
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            if (colorSpaceName != null) {
                colorSpace = this.resources.getColorSpace(colorSpaceName);
                if (colorSpace != null) {
                    colorSpaces.add(ColorSpaceFactory.getColorSpace(colorSpace, this.document, null));
                    return Collections.unmodifiableList(colorSpaces);
                }
            } else if (colorSpace != null) {
                colorSpaces.add(ColorSpaceFactory.getColorSpace(colorSpace, this.document, null));
                return Collections.unmodifiableList(colorSpaces);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

