/**
 * This file is part of veraPDF PDF Box PDF/A Validation Model Implementation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF Box PDF/A Validation Model Implementation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF Box PDF/A Validation Model Implementation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF Box PDF/A Validation Model Implementation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.impl.pb.operator.textshow;

/**
 * @author Maxim Plushchov
 */
public class PUAHelper {

    private static final int[] UNICODE_PRIVATE_USE_AREA_ARRAY = {0xE000, 0xF8FF, 0xF0000, 0xFFFFD, 0x100000, 0x10FFFD};

    public static Boolean containPUA(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            int unicode = string.codePointAt(i);
            if ((unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[0] &&
                    unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[1]) ||
                    (unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[2] &&
                            unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[3]) ||
                    (unicode >= UNICODE_PRIVATE_USE_AREA_ARRAY[4] &&
                            unicode <= UNICODE_PRIVATE_USE_AREA_ARRAY[5])) {
                return true;
            }
        }
        return false;
    }

}
