/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.verapdf.model.impl.pb.pd.PBoxPDFormField;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.signatures.PBoxPDSignatureField;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.impl.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PBoxPDAcroForm
extends PBoxPDObject
implements PDAcroForm {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDAcroForm.class.getCanonicalName());
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";
    public static final String XDP = "xdp:xdp";
    public static final String CONFIG = "config";
    public static final String ACROBAT = "acrobat";
    public static final String ACROBAT7 = "acrobat7";
    public static final String DYNAMIC_RENDER = "dynamicRender";
    private final boolean needAppearance;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDAcroForm(org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm acroForm, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)acroForm, ACRO_FORM_TYPE);
        this.needAppearance = acroForm.getNeedAppearances();
        this.document = document;
        this.flavour = flavour;
    }

    public Boolean getNeedAppearances() {
        return this.needAppearance;
    }

    public Boolean getcontainsXFA() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.XFA);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getdynamicRender() {
        COSBase object = ((COSDictionary)this.simplePDObject.getCOSObject()).getItem(COSName.XFA);
        if (object == null) {
            return null;
        }
        if (object instanceof COSArray) {
            COSArray array = (COSArray)object;
            COSBase afterConfig = null;
            for (int i = 0; i < array.size() - 1; ++i) {
                COSBase element = array.get(i);
                if (!(element instanceof COSString) || !CONFIG.equals(((COSString)element).getString())) continue;
                afterConfig = ((COSObject)array.get(i + 1)).getObject();
                break;
            }
            object = afterConfig;
        }
        if (!(object instanceof COSStream)) return null;
        try (InputStream asInputStream = ((COSStream)object).getUnfilteredStream();){
            Node config;
            Node acrobat;
            Node acrobat7;
            Node dynamicRender;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(null);
            Document doc = builder.parse(new InputSource(new ByteBuffer(asInputStream).getByteStream()));
            Node configParent = this.getProperty(doc, XDP);
            if (configParent == null) {
                configParent = doc;
            }
            if ((dynamicRender = this.getProperty(acrobat7 = this.getProperty(acrobat = this.getProperty(config = this.getProperty(configParent, CONFIG), ACROBAT), ACROBAT7), DYNAMIC_RENDER)) == null) return null;
            String string = dynamicRender.getChildNodes().item(0).getNodeValue();
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problems with parsing XFA");
            return null;
        }
    }

    private Node getProperty(Node parent, String propertyName) {
        if (parent == null) {
            return null;
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!propertyName.equals(item.getNodeName())) continue;
            return item;
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List fields = ((org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<PBoxPDFormField> formFields = new ArrayList<PBoxPDFormField>(1);
        for (PDField field : fields) {
            if (field instanceof PDSignatureField) {
                formFields.add(new PBoxPDSignatureField((PDSignatureField)field, this.document));
                continue;
            }
            formFields.add(new PBoxPDFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }
}

