/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractICCProfileFeaturesExtractor;
import org.verapdf.features.ICCProfileFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class ICCProfileSampleExtractor
extends AbstractICCProfileFeaturesExtractor {
    private static final Logger LOGGER = Logger.getLogger(ICCProfileSampleExtractor.class.getCanonicalName());

    public List<FeatureTreeNode> getICCProfileFeatures(ICCProfileFeaturesData iccProfileFeaturesData) {
        ArrayList<FeatureTreeNode> res = new ArrayList<FeatureTreeNode>();
        try {
            FeatureTreeNode stream = FeatureTreeNode.createRootNode((String)"streamContent");
            stream.setValue(DatatypeConverter.printHexBinary((byte[])ICCProfileSampleExtractor.inputStreamToByteArray(iccProfileFeaturesData.getStream())));
            res.add(stream);
            InputStream meta = iccProfileFeaturesData.getMetadata();
            if (meta != null) {
                FeatureTreeNode metadata = FeatureTreeNode.createRootNode((String)"metadataStreamContent");
                metadata.setValue(DatatypeConverter.printHexBinary((byte[])ICCProfileSampleExtractor.inputStreamToByteArray(meta)));
                res.add(metadata);
            }
            ICCProfileSampleExtractor.addObjectNode("nValue", iccProfileFeaturesData.getN(), res);
            List range = iccProfileFeaturesData.getRange();
            if (range != null) {
                FeatureTreeNode rangeNode = FeatureTreeNode.createRootNode((String)"range");
                res.add(rangeNode);
                for (int i = 0; i < range.size(); ++i) {
                    Double obj = (Double)range.get(i);
                    if (obj == null) continue;
                    FeatureTreeNode entry = rangeNode.addChild("entry");
                    entry.setValue(obj.toString());
                    entry.setAttribute("index", String.valueOf(i));
                }
            }
        }
        catch (IOException | FeatureParsingException e) {
            LOGGER.log(Level.WARNING, "Some failure in ICC scampler", e);
        }
        return res;
    }

    private static FeatureTreeNode addObjectNode(String nodeName, Object toAdd, List<FeatureTreeNode> list) throws FeatureParsingException {
        FeatureTreeNode node = null;
        if (toAdd != null) {
            node = FeatureTreeNode.createRootNode((String)nodeName);
            list.add(node);
            node.setValue(toAdd.toString());
        }
        return node;
    }

    private static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }
}

