/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractImageFeaturesExtractor;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class ImageSampleExtractor
extends AbstractImageFeaturesExtractor {
    private static final Logger LOGGER = Logger.getLogger(ImageSampleExtractor.class);

    public List<FeatureTreeNode> getImageFeatures(ImageFeaturesData imageFeaturesData) {
        ArrayList<FeatureTreeNode> res = new ArrayList<FeatureTreeNode>();
        try {
            FeatureTreeNode stream = FeatureTreeNode.createRootNode((String)"streamContent");
            stream.setValue(DatatypeConverter.printHexBinary((byte[])imageFeaturesData.getStream()));
            res.add(stream);
            byte[] meta = imageFeaturesData.getMetadata();
            if (meta != null) {
                FeatureTreeNode metadata = FeatureTreeNode.createRootNode((String)"metadataStreamContent");
                metadata.setValue(DatatypeConverter.printHexBinary((byte[])meta));
                res.add(metadata);
            }
            ImageSampleExtractor.addObjectNode("width", imageFeaturesData.getWidth(), res);
            ImageSampleExtractor.addObjectNode("height", imageFeaturesData.getHeight(), res);
            List filters = imageFeaturesData.getFilters();
            if (filters != null) {
                FeatureTreeNode filtersNode = FeatureTreeNode.createRootNode((String)"filters");
                res.add(filtersNode);
                for (ImageFeaturesData.Filter filter : filters) {
                    byte[] streamF;
                    FeatureTreeNode filterNode = FeatureTreeNode.createChildNode((String)"filter", (FeatureTreeNode)filtersNode);
                    filterNode.setAttribute("name", String.valueOf(filter.getName()));
                    Map properties = filter.getProperties();
                    if (properties != null) {
                        for (Map.Entry entry : properties.entrySet()) {
                            FeatureTreeNode.createChildNode((String)String.valueOf(entry.getKey()), (FeatureTreeNode)filterNode).setValue(String.valueOf(entry.getValue()));
                        }
                    }
                    if ((streamF = filter.getStream()) == null) continue;
                    String streamContent = DatatypeConverter.printHexBinary((byte[])streamF);
                    FeatureTreeNode.createChildNode((String)"stream", (FeatureTreeNode)filterNode).setValue(streamContent);
                }
            }
        }
        catch (FeatureParsingException e) {
            LOGGER.error((Object)"Some fail in logic", (Throwable)e);
        }
        return res;
    }

    private static FeatureTreeNode addObjectNode(String nodeName, Object toAdd, List<FeatureTreeNode> list) throws FeatureParsingException {
        FeatureTreeNode node = null;
        if (toAdd != null) {
            node = FeatureTreeNode.createRootNode((String)nodeName);
            list.add(node);
            node.setValue(toAdd.toString());
        }
        return node;
    }
}

