/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractImageFeaturesExtractor;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JpylyzerExtractor
extends AbstractImageFeaturesExtractor {
    public List<FeatureTreeNode> getImageFeatures(ImageFeaturesData imageFeaturesData) {
        boolean doesContainsJPXFilter = false;
        for (ImageFeaturesData.Filter filter : imageFeaturesData.getFilters()) {
            if (!"JPXDecode".equals(filter.getName())) continue;
            doesContainsJPXFilter = true;
            break;
        }
        if (!doesContainsJPXFilter) {
            return null;
        }
        ArrayList<FeatureTreeNode> result = new ArrayList<FeatureTreeNode>();
        try {
            try {
                File temp = this.generateTempFile(imageFeaturesData.getStream(), "jpx");
                this.exec(result, temp);
            }
            catch (IOException | InterruptedException | URISyntaxException e) {
                FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
                node.setValue("Error in execution. Error message: " + e.getMessage());
                result.add(node);
            }
        }
        catch (FeatureParsingException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private File generateTempFile(byte[] stream, String name) throws IOException {
        File fold = JpylyzerExtractor.getTempFolder();
        File temp = File.createTempFile(name == null ? "" : name, "", fold);
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        out.write(stream);
        out.close();
        return temp;
    }

    private void exec(List<FeatureTreeNode> nodes, File temp) throws InterruptedException, FeatureParsingException, IOException, URISyntaxException {
        int bytesRead;
        String scriptPath = (String)this.getAttributes().get("cliPath");
        if (scriptPath == null) {
            FeatureTreeNode error = FeatureTreeNode.createRootNode((String)"error");
            error.setValue("Can not obtain jpylyzer script or binary");
            nodes.add(error);
            return;
        }
        String isVerbose = (String)this.getAttributes().get("isVerbose");
        String[] args = isVerbose != null && Boolean.valueOf(isVerbose) != false ? new String[]{scriptPath, "--verbose", temp.getCanonicalPath()} : new String[]{scriptPath, temp.getCanonicalPath()};
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec(args);
        File out = JpylyzerExtractor.getOutFile((String)this.getAttributes().get("outFolder"), nodes);
        FileOutputStream outStream = new FileOutputStream(out);
        byte[] buffer = new byte[1024];
        while ((bytesRead = pr.getInputStream().read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        pr.waitFor();
        outStream.close();
        FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"resultPath");
        node.setValue(out.getCanonicalPath());
        nodes.add(node);
        try {
            String isValidJP2Value = JpylyzerExtractor.getXMLNodeValue("//jpylyzer/isValidJP2", out);
            FeatureTreeNode validationNode = FeatureTreeNode.createRootNode((String)"isValidJP2");
            validationNode.setValue(isValidJP2Value);
            nodes.add(validationNode);
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            FeatureTreeNode error = FeatureTreeNode.createRootNode((String)"error");
            error.setValue("Error in obtaining validation result. Error message: " + e.getMessage());
            nodes.add(error);
        }
    }

    private static String getXMLNodeValue(String xPath, File xml) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xml);
        XPathExpression xp = XPathFactory.newInstance().newXPath().compile(xPath);
        return xp.evaluate(document);
    }

    private static File getOutFile(String outPath, List<FeatureTreeNode> nodes) throws FeatureParsingException, IOException {
        if (outPath == null) {
            File tempFolder = JpylyzerExtractor.getTempFolder();
            return JpylyzerExtractor.getOutFileInFolder(tempFolder);
        }
        File outFolder = new File(outPath);
        if (outFolder.isDirectory()) {
            return JpylyzerExtractor.getOutFileInFolder(outFolder);
        }
        FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
        node.setValue("Config file contains out folder path but it doesn't link a directory.");
        nodes.add(node);
        File tempFolder = JpylyzerExtractor.getTempFolder();
        return JpylyzerExtractor.getOutFileInFolder(tempFolder);
    }

    private static File getTempFolder() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFolder = new File(tempDir, "veraPDFJpylyzerPluginTemp");
        if (!tempFolder.exists()) {
            tempFolder.mkdir();
        }
        tempFolder.deleteOnExit();
        return tempFolder;
    }

    private static File getOutFileInFolder(File folder) throws IOException {
        File out = File.createTempFile("veraPDF_Jpylyzer_Plugin_out", ".xml", folder);
        out.deleteOnExit();
        return out;
    }
}

