/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.verapdf.MediaConchConfig;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractEmbeddedFileFeaturesExtractor;
import org.verapdf.features.EmbeddedFileFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class MediaConchExtractor
extends AbstractEmbeddedFileFeaturesExtractor {
    private static final String ID = "8725b233-1597-490e-9b45-b989303d2c5b";
    private static final String DESCRIPTION = "Generates mediaconch report of the given embedded video file";

    public MediaConchExtractor() {
        super(ID, DESCRIPTION);
    }

    public List<FeatureTreeNode> getEmbeddedFileFeatures(EmbeddedFileFeaturesData embeddedFileFeaturesData) {
        if (!this.isValidType(embeddedFileFeaturesData.getSubtype())) {
            return null;
        }
        ArrayList<FeatureTreeNode> result = new ArrayList<FeatureTreeNode>();
        try {
            try {
                MediaConchConfig config = this.getConfig(result);
                File temp = this.generateTempFile(embeddedFileFeaturesData.getStream(), embeddedFileFeaturesData.getName());
                this.execCLI(result, config, temp);
            }
            catch (IOException | InterruptedException e) {
                FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
                node.setValue("Error in execution. Error message: " + e.getMessage());
                result.add(node);
            }
        }
        catch (FeatureParsingException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private File generateTempFile(byte[] stream, String name) throws IOException {
        File fold = this.getTempFolder();
        File temp = File.createTempFile(name == null ? "" : name, "", fold);
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        out.write(stream);
        out.close();
        return temp;
    }

    private void execCLI(List<FeatureTreeNode> nodes, MediaConchConfig config, File temp) throws InterruptedException, FeatureParsingException, IOException {
        int bytesRead;
        Runtime rt = Runtime.getRuntime();
        String configCliPath = config.getCliPath();
        String cliPath = configCliPath == null || configCliPath.isEmpty() ? "mediaconch" : configCliPath;
        File out = this.getOutFile(config, nodes);
        String[] str = new String[]{cliPath, "-mc", "-fx", temp.getCanonicalPath()};
        Process pr = rt.exec(str);
        FileOutputStream outStream = new FileOutputStream(out);
        byte[] buffer = new byte[1024];
        while ((bytesRead = pr.getInputStream().read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        pr.waitFor();
        FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"resultPath");
        node.setValue(out.getCanonicalPath());
        nodes.add(node);
    }

    private File getOutFile(MediaConchConfig config, List<FeatureTreeNode> nodes) throws FeatureParsingException, IOException {
        if (config.getOutFolder() == null) {
            return this.getOutFileInFolder(this.getTempFolder());
        }
        File outFolder = new File(config.getOutFolder());
        if (outFolder.isDirectory()) {
            return this.getOutFileInFolder(outFolder);
        }
        FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
        node.setValue("Config file contains out folder path but it doesn't link a directory.");
        nodes.add(node);
        return this.getOutFileInFolder(this.getTempFolder());
    }

    private File getTempFolder() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFolder = new File(tempDir, "veraPDFMediaConchPluginTemp");
        if (!tempFolder.exists()) {
            tempFolder.mkdir();
        }
        return tempFolder;
    }

    private File getOutFileInFolder(File folder) throws IOException {
        return File.createTempFile("veraPDF_MediaConch_Plugin_out", ".xml", folder);
    }

    private MediaConchConfig getConfig(List<FeatureTreeNode> nodes) throws FeatureParsingException {
        MediaConchConfig config = MediaConchConfig.defaultInstance();
        File conf = this.getConfigFile();
        if (conf.isFile() && conf.canRead()) {
            try {
                config = MediaConchConfig.fromXml(new FileInputStream(conf));
            }
            catch (FileNotFoundException | JAXBException e) {
                FeatureTreeNode node = FeatureTreeNode.createRootNode((String)"error");
                node.setValue("Config file contains wrong syntax. Error message: " + e.getMessage());
                nodes.add(node);
            }
        }
        return config;
    }

    private File getConfigFile() {
        return new File("config.xml");
    }

    private boolean isValidType(String type) {
        return type.toLowerCase().startsWith("video/");
    }
}

