/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaWindow;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.A3DActivation;
import org.verapdf.model.alayer.ARichMediaWindow;
import org.verapdf.model.baselayer.Object;

public class GFA3DActivation
extends GFAObject
implements A3DActivation {
    public GFA3DActivation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "A3DActivation");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Window": {
                return this.getWindow();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ARichMediaWindow> getWindow() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWindow1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaWindow> getWindow1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Window"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaWindow> list = new ArrayList<GFARichMediaWindow>(1);
            list.add(new GFARichMediaWindow((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Window"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsStyle() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Style"));
    }

    public Boolean getStyleHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Style"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getStyleNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Style"));
        if (object == null || object.empty()) {
            return this.getStyleNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getStyleNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return "Embedded";
            }
        }
        return null;
    }

    public Boolean getcontainsD() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"D"));
    }

    public Boolean getDHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"D"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getDNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"D"));
        if (object == null || object.empty()) {
            return this.getDNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getDNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return "PI";
            }
        }
        return null;
    }

    public Boolean getcontainsTB() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TB"));
    }

    public Boolean getTBHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TB"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsA() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"A"));
    }

    public Boolean getAHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"A"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getANameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"A"));
        if (object == null || object.empty()) {
            return this.getANameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getANameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return "XA";
            }
        }
        return null;
    }

    public Boolean getcontainsWindow() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Window"));
    }

    public Boolean getWindowHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Window"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsAIS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AIS"));
    }

    public Boolean getAISHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AIS"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getAISNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AIS"));
        if (object == null || object.empty()) {
            return this.getAISNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getAISNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return "L";
            }
        }
        return null;
    }

    public Boolean getcontainsTransparent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Transparent"));
    }

    public Boolean getTransparentHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Transparent"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsNP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"NP"));
    }

    public Boolean getNPHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"NP"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getcontainsDIS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DIS"));
    }

    public Boolean getDISHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DIS"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getDISNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DIS"));
        if (object == null || object.empty()) {
            return this.getDISNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getDISNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_6: {
                return "U";
            }
        }
        return null;
    }
}

