/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_4Integers;
import org.verapdf.gf.model.impl.arlington.GFADocTimeStamp;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf_4Integers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.baselayer.Object;

public class GFAAuthCode
extends GFAObject
implements AAuthCode {
    public GFAAuthCode(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AAuthCode");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ByteRange": {
                return this.getByteRange();
            }
            case "SigObjRef": {
                return this.getSigObjRef();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf_4Integers> getByteRange() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getByteRange2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_4Integers> getByteRange2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_4Integers> list = new ArrayList<GFAArrayOf_4Integers>(1);
            list.add(new GFAArrayOf_4Integers((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ByteRange"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<Object> getSigObjRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getSigObjRef2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getSigObjRef2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SigObjRef"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getSigObjRefDictionary2_0(object.getDirectBase(), "SigObjRef");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getSigObjRefDictionary2_0(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Sig": {
                return new GFASignature(base, this.baseObject, keyName);
            }
            case "DocTimeStamp": {
                return new GFADocTimeStamp(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getcontainsSigObjRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SigObjRef"));
    }

    public Boolean getisSigObjRefIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SigObjRef"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getSigObjRefHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SigObjRef"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsByteRange() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ByteRange"));
    }

    public Boolean getisByteRangeIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getByteRangeHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsMAC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"MAC"));
    }

    public Boolean getisMACIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MAC"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getMACHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MAC"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsMACLocation() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"MACLocation"));
    }

    public Boolean getisMACLocationIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MACLocation"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getMACLocationHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MACLocation"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getMACLocationNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"MACLocation"));
        if (object == null || object.empty()) {
            return this.getMACLocationNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getMACLocationNameDefaultValue() {
        return null;
    }

    public Long getByteRange1IntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject ByteRange = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (ByteRange.size() <= 1) {
            return null;
        }
        COSObject entry1 = ByteRange.at(1);
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry1IntegerValue();
    }

    public Long getByteRange2IntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject ByteRange = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (ByteRange.size() <= 2) {
            return null;
        }
        COSObject entry2 = ByteRange.at(2);
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry2IntegerValue();
    }

    public Long getByteRange0IntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject ByteRange = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (ByteRange.size() <= 0) {
            return null;
        }
        COSObject entry0 = ByteRange.at(0);
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry0IntegerValue();
    }

    public Long getByteRange3IntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject ByteRange = this.baseObject.getKey(ASAtom.getASAtom((String)"ByteRange"));
        if (ByteRange == null || ByteRange.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        if (ByteRange.size() <= 3) {
            return null;
        }
        COSObject entry3 = ByteRange.at(3);
        return new GFAArrayOf_4Integers(ByteRange.getDirectBase(), null, null).getentry3IntegerValue();
    }
}

