/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFADocInfoEntry;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.ADocInfoEntry;
import org.verapdf.model.baselayer.Object;

public class GFADocInfo
extends GFAObject
implements ADocInfo {
    public GFADocInfo(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ADocInfo");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ADocInfoEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: {
                return this.getEntries1_1();
            }
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<ADocInfoEntry> getEntries1_1() {
        LinkedList<GFADocInfoEntry> list = new LinkedList<GFADocInfoEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Producer".equals(key.getValue()) || "Creator".equals(key.getValue()) || "CreationDate".equals(key.getValue()) || "Keywords".equals(key.getValue()) || "ModDate".equals(key.getValue()) || "Subject".equals(key.getValue()) || "Author".equals(key.getValue()) || "Title".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFADocInfoEntry(object != null ? object.get() : null, this.baseObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<ADocInfoEntry> getEntries1_3() {
        LinkedList<GFADocInfoEntry> list = new LinkedList<GFADocInfoEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("Author".equals(key.getValue()) || "Keywords".equals(key.getValue()) || "Trapped".equals(key.getValue()) || "Creator".equals(key.getValue()) || "Producer".equals(key.getValue()) || "ModDate".equals(key.getValue()) || "CreationDate".equals(key.getValue()) || "Title".equals(key.getValue()) || "Subject".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFADocInfoEntry(object != null ? object.get() : null, this.baseObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    public Boolean getcontainsCreator() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Creator"));
    }

    public Boolean getCreatorHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Creator"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsTitle() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Title"));
    }

    public Boolean getTitleHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Title"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsCreationDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CreationDate"));
    }

    public Boolean getCreationDateHasTypeDate() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CreationDate"));
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])");
    }

    public Boolean getcontainsTrapped() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Trapped"));
    }

    public Boolean getTrappedHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Trapped"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTrappedNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Trapped"));
        if (object == null || object.empty()) {
            return this.getTrappedNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTrappedNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return "Unknown";
            }
        }
        return null;
    }

    public Boolean getcontainsModDate() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ModDate"));
    }

    public Boolean getModDateHasTypeDate() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ModDate"));
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])");
    }

    public Boolean getcontainsAuthor() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Author"));
    }

    public Boolean getAuthorHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Author"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsKeywords() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Keywords"));
    }

    public Boolean getKeywordsHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Keywords"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsProducer() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Producer"));
    }

    public Boolean getProducerHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Producer"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsSubject() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subject"));
    }

    public Boolean getSubjectHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subject"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }
}

