/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStringsByte;
import org.verapdf.model.alayer.AEncryptionPublicKey;
import org.verapdf.model.baselayer.Object;

public class GFAEncryptionPublicKey
extends GFAObject
implements AEncryptionPublicKey {
    public GFAEncryptionPublicKey(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AEncryptionPublicKey");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CF": {
                return this.getCF();
            }
            case "Recipients": {
                return this.getRecipients();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getCF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getCF1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            List list = Collections.emptyList();
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getRecipients1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStringsByte> getRecipients1_3() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Recipients"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStringsByte> list = new ArrayList<GFAArrayOfStringsByte>(1);
            list.add(new GFAArrayOfStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Recipients"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CF"));
    }

    public Boolean getCFHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CF"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public Boolean getFilterHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getFilterNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (object == null || object.empty()) {
            return this.getFilterNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getFilterNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsKDFSalt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"KDFSalt"));
    }

    public Boolean getisKDFSaltIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getKDFSaltHasTypeStringByte() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"KDFSalt"));
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public Boolean getVHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getVIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        if (object == null || object.empty()) {
            return this.getVIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getVIntegerDefaultValue() {
        return null;
    }

    public Boolean getcontainsSubFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"SubFilter"));
    }

    public Boolean getSubFilterHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubFilter"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSubFilterNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"SubFilter"));
        if (object == null || object.empty()) {
            return this.getSubFilterNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSubFilterNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsStmF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StmF"));
    }

    public Boolean getStmFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StmF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"P"));
    }

    public Boolean getPHasTypeBitmask() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPBitmaskValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"P"));
        if (object == null || object.empty()) {
            return this.getPBitmaskDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getPBitmaskDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return 0L;
            }
        }
        return null;
    }

    public Boolean getcontainsRecipients() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Recipients"));
    }

    public Boolean getRecipientsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Recipients"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getLengthIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        if (object == null || object.empty()) {
            return this.getLengthIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getLengthIntegerDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: {
                return 40L;
            }
        }
        return null;
    }

    public Boolean getcontainsStrF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StrF"));
    }

    public Boolean getStrFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StrF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsEFF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EFF"));
    }

    public Boolean getEFFHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EFF"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getcontainsEncryptMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"EncryptMetadata"));
    }

    public Boolean getEncryptMetadataHasTypeBoolean() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"EncryptMetadata"));
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean gethasExtensionADBE_Extn3() {
        return false;
    }
}

