/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf_2UnencryptedStringsByte;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf_2UnencryptedStringsByte;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileTrailer;

public class GFAFileTrailer
extends GFAObject
implements AFileTrailer {
    public GFAFileTrailer(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AFileTrailer");
        GFAObject.clearAllContainers();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Root": {
                return this.getRoot();
            }
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Info": {
                return this.getInfo();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACatalog> getRoot() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getRoot1_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot1_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Root"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthCode"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_2UnencryptedStringsByte> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getentryID1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf_2UnencryptedStringsByte> getentryID1_1() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf_2UnencryptedStringsByte> list = new ArrayList<GFAArrayOf_2UnencryptedStringsByte>(1);
            list.add(new GFAArrayOf_2UnencryptedStringsByte((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getInfo1_0();
            }
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo1_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEncrypt1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_1() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_1(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_1(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Prev"));
    }

    public Boolean getisPrevIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Prev"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getPrevHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Prev"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPrevIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Prev"));
        if (object == null || object.empty()) {
            return this.getPrevIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getPrevIntegerDefaultValue() {
        return null;
    }

    public Boolean getcontainsXRefStm() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"XRefStm"));
    }

    public Boolean getXRefStmHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"XRefStm"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getXRefStmIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"XRefStm"));
        if (object == null || object.empty()) {
            return this.getXRefStmIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getXRefStmIntegerDefaultValue() {
        return null;
    }

    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ID"));
    }

    public Boolean getisentryIDIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getentryIDHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Root"));
    }

    public Boolean getisRootIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Root"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getRootHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Root"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Size"));
    }

    public Boolean getisSizeIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getSizeHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getSizeIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        if (object == null || object.empty()) {
            return this.getSizeIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getSizeIntegerDefaultValue() {
        return null;
    }

    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Info"));
    }

    public Boolean getisInfoIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getInfoHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Encrypt"));
    }

    public Boolean getEncryptHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AuthCode"));
    }

    public Boolean getisAuthCodeIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthCode"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthCode"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Long getEncryptVIntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom((String)"V"));
        if (V != null && V.getType() == COSObjType.COS_INTEGER) {
            return V.getInteger();
        }
        return null;
    }
}

