/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOf3DView;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRichMediaConfiguration;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaContentNameTreeAssets;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOf3DView;
import org.verapdf.model.alayer.AArrayOfRichMediaConfiguration;
import org.verapdf.model.alayer.ARichMediaContent;
import org.verapdf.model.alayer.ARichMediaContentNameTreeAssets;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaContent
extends GFAObject
implements ARichMediaContent {
    public GFARichMediaContent(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaContent");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Views": {
                return this.getViews();
            }
            case "Assets": {
                return this.getAssets();
            }
            case "Configurations": {
                return this.getConfigurations();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOf3DView> getViews() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getViews1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOf3DView> getViews1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Views"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOf3DView> list = new ArrayList<GFAArrayOf3DView>(1);
            list.add(new GFAArrayOf3DView((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Views"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaContentNameTreeAssets> getAssets() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAssets1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaContentNameTreeAssets> getAssets1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Assets"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaContentNameTreeAssets> list = new ArrayList<GFARichMediaContentNameTreeAssets>(1);
            list.add(new GFARichMediaContentNameTreeAssets((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Assets"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaConfiguration> getConfigurations() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getConfigurations1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaConfiguration> getConfigurations1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Configurations"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRichMediaConfiguration> list = new ArrayList<GFAArrayOfRichMediaConfiguration>(1);
            list.add(new GFAArrayOfRichMediaConfiguration((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Configurations"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAssets() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Assets"));
    }

    public Boolean getAssetsHasTypeNameTree() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Assets"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsConfigurations() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Configurations"));
    }

    public Boolean getConfigurationsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Configurations"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Long getConfigurationsArraySize() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Configurations"));
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsViews() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Views"));
    }

    public Boolean getViewsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Views"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }
}

