/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARichMediaParams;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ARichMediaInstance;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaInstance
extends GFAObject
implements ARichMediaInstance {
    public GFARichMediaInstance(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaInstance");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Asset": {
                return this.getAsset();
            }
            case "Params": {
                return this.getParams();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AFileSpecification> getAsset() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAsset1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getAsset1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Asset"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Asset"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getParams1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ARichMediaParams> getParams1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Params"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARichMediaParams> list = new ArrayList<GFARichMediaParams>(1);
            list.add(new GFARichMediaParams((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Params"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAsset() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Asset"));
    }

    public Boolean getAssetHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Asset"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsParams() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Params"));
    }

    public Boolean getParamsHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Params"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSubtypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (object == null || object.empty()) {
            return this.getSubtypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSubtypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsScene() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Scene"));
    }

    public Boolean getSceneHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Scene"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getSceneIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Scene"));
        if (object == null || object.empty()) {
            return this.getSceneIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getSceneIntegerDefaultValue() {
        return null;
    }
}

