/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRichMediaCuePoints;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfRichMediaCuePoints;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaParams
extends GFAObject
implements ARichMediaParams {
    public GFARichMediaParams(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaParams");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Seetings": {
                return this.getSeetings();
            }
            case "FlashVars": {
                return this.getFlashVars();
            }
            case "CuePoints": {
                return this.getCuePoints();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AStream> getSeetings() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSeetings1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getSeetings1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Seetings"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Seetings"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFlashVars1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "FlashVars"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCuePoints1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CuePoints"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRichMediaCuePoints> list = new ArrayList<GFAArrayOfRichMediaCuePoints>(1);
            list.add(new GFAArrayOfRichMediaCuePoints((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "CuePoints"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsBinding() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Binding"));
    }

    public Boolean getBindingHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Binding"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getBindingNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Binding"));
        if (object == null || object.empty()) {
            return this.getBindingNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getBindingNameDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return "None";
            }
        }
        return null;
    }

    public Boolean getcontainsSeetings() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Seetings"));
    }

    public Boolean getisSeetingsIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Seetings"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getSeetingsHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Seetings"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getSeetingsHasTypeStream() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Seetings"));
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getcontainsCuePoints() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CuePoints"));
    }

    public Boolean getCuePointsHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CuePoints"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsBindingMaterial() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BindingMaterial"));
    }

    public Boolean getBindingMaterialHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BindingMaterial"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsFlashVars() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FlashVars"));
    }

    public Boolean getisFlashVarsIndirect() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getFlashVarsHasTypeStringText() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getFlashVarsHasTypeStream() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }
}

