/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.gf.model.impl.arlington.GFABlackpointArray;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAWhitepointArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ABlackpointArray;
import org.verapdf.model.alayer.ACalGrayDict;
import org.verapdf.model.alayer.AWhitepointArray;
import org.verapdf.model.baselayer.Object;

public class GFACalGrayDict
extends GFAObject
implements ACalGrayDict {
    public GFACalGrayDict(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ACalGrayDict");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "BlackPoint": {
                return this.getBlackPoint();
            }
            case "WhitePoint": {
                return this.getWhitePoint();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ABlackpointArray> getBlackPoint() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getBlackPoint1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<ABlackpointArray> getBlackPoint1_1() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BlackPoint"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFABlackpointArray> list = new ArrayList<GFABlackpointArray>(1);
            list.add(new GFABlackpointArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "BlackPoint"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AWhitepointArray> getWhitePoint() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getWhitePoint1_1();
            }
        }
        return Collections.emptyList();
    }

    private List<AWhitepointArray> getWhitePoint1_1() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"WhitePoint"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAWhitepointArray> list = new ArrayList<GFAWhitepointArray>(1);
            list.add(new GFAWhitepointArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "WhitePoint"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsBlackPoint() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BlackPoint"));
    }

    public COSObject getBlackPointValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BlackPoint"));
        return object;
    }

    public Boolean getBlackPointHasTypeArray() {
        COSObject object = this.getBlackPointValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsGamma() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Gamma"));
    }

    public COSObject getGammaDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSReal.construct((double)1.0);
            }
        }
        return null;
    }

    public COSObject getGammaValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Gamma"));
        if (object == null || object.empty()) {
            object = this.getGammaDefaultValue();
        }
        return object;
    }

    public Boolean getGammaHasTypeNumber() {
        COSObject object = this.getGammaValue();
        return object != null && object.getType().isNumber();
    }

    public Double getGammaNumberValue() {
        COSObject object = this.getGammaValue();
        if (object != null && object.getType().isNumber()) {
            return object.getReal();
        }
        return null;
    }

    public Boolean getcontainsWhitePoint() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"WhitePoint"));
    }

    public COSObject getWhitePointValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"WhitePoint"));
        return object;
    }

    public Boolean getWhitePointHasTypeArray() {
        COSObject object = this.getWhitePointValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }
}

