/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.APermissions;
import org.verapdf.model.alayer.ASignature;
import org.verapdf.model.baselayer.Object;

public class GFAPermissions
extends GFAObject
implements APermissions {
    public GFAPermissions(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "APermissions");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "DocMDP": {
                return this.getDocMDP();
            }
            case "UR3": {
                return this.getUR3();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ASignature> getDocMDP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDocMDP1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ASignature> getDocMDP1_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DocMDP"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASignature> list = new ArrayList<GFASignature>(1);
            list.add(new GFASignature((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "DocMDP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ASignature> getUR3() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getUR31_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ASignature> getUR31_5() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UR3"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFASignature> list = new ArrayList<GFASignature>(1);
            list.add(new GFASignature((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "UR3"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsDocMDP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DocMDP"));
    }

    public COSObject getDocMDPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DocMDP"));
        return object;
    }

    public Boolean getisDocMDPIndirect() {
        COSObject object = this.getDocMDPValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getDocMDPHasTypeDictionary() {
        COSObject object = this.getDocMDPValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsUR3() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"UR3"));
    }

    public COSObject getUR3Value() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UR3"));
        return object;
    }

    public Boolean getUR3HasTypeDictionary() {
        COSObject object = this.getUR3Value();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Long getDocMDPReferenceArraySize() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject DocMDP = this.baseObject.getKey(ASAtom.getASAtom((String)"DocMDP"));
        if (DocMDP == null || !DocMDP.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Reference = DocMDP.getKey(ASAtom.getASAtom((String)"Reference"));
        if (Reference != null && Reference.getType() == COSObjType.COS_ARRAY) {
            return (long)Reference.size();
        }
        return null;
    }

    public Boolean getDocMDPReferenceHasTypeArray() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject DocMDP = this.baseObject.getKey(ASAtom.getASAtom((String)"DocMDP"));
        if (DocMDP == null || !DocMDP.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Reference = DocMDP.getKey(ASAtom.getASAtom((String)"Reference"));
        return Reference != null && Reference.getType() == COSObjType.COS_ARRAY;
    }
}

