/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRichMediaCuePoints;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfRichMediaCuePoints;
import org.verapdf.model.alayer.ARichMediaParams;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.baselayer.Object;

public class GFARichMediaParams
extends GFAObject
implements ARichMediaParams {
    public GFARichMediaParams(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARichMediaParams");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CuePoints": {
                return this.getCuePoints();
            }
            case "FlashVars": {
                return this.getFlashVars();
            }
            case "Settings": {
                return this.getSettings();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCuePoints1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfRichMediaCuePoints> getCuePoints1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CuePoints"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRichMediaCuePoints> list = new ArrayList<GFAArrayOfRichMediaCuePoints>(1);
            list.add(new GFAArrayOfRichMediaCuePoints((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "CuePoints"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFlashVars1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getFlashVars1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "FlashVars"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getSettings() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getSettings1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getSettings1_7() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Settings"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Settings"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsBinding() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Binding"));
    }

    public COSObject getBindingDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSName.construct((String)"None");
            }
        }
        return null;
    }

    public COSObject getBindingValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Binding"));
        if (object == null || object.empty()) {
            object = this.getBindingDefaultValue();
        }
        return object;
    }

    public Boolean getBindingHasTypeName() {
        COSObject object = this.getBindingValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getBindingNameValue() {
        COSObject object = this.getBindingValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsBindingMaterial() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BindingMaterial"));
    }

    public COSObject getBindingMaterialValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BindingMaterial"));
        return object;
    }

    public Boolean getBindingMaterialHasTypeStringText() {
        COSObject object = this.getBindingMaterialValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsCuePoints() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CuePoints"));
    }

    public COSObject getCuePointsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CuePoints"));
        return object;
    }

    public Boolean getCuePointsHasTypeArray() {
        COSObject object = this.getCuePointsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsFlashVars() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FlashVars"));
    }

    public COSObject getFlashVarsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FlashVars"));
        return object;
    }

    public Boolean getisFlashVarsIndirect() {
        COSObject object = this.getFlashVarsValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getFlashVarsHasTypeStream() {
        COSObject object = this.getFlashVarsValue();
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getFlashVarsHasTypeStringText() {
        COSObject object = this.getFlashVarsValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsSettings() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Settings"));
    }

    public COSObject getSettingsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Settings"));
        return object;
    }

    public Boolean getisSettingsIndirect() {
        COSObject object = this.getSettingsValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getSettingsHasTypeStream() {
        COSObject object = this.getSettingsValue();
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getSettingsHasTypeStringText() {
        COSObject object = this.getSettingsValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }
}

