/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAURLAlias;
import org.verapdf.gf.model.impl.arlington.GFAWebCaptureCommand;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASourceInformation;
import org.verapdf.model.alayer.AURLAlias;
import org.verapdf.model.alayer.AWebCaptureCommand;
import org.verapdf.model.baselayer.Object;

public class GFASourceInformation
extends GFAObject
implements ASourceInformation {
    public GFASourceInformation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASourceInformation");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "AU": {
                return this.getAU();
            }
            case "C": {
                return this.getC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AURLAlias> getAU() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAU1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AURLAlias> getAU1_3() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AU"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAURLAlias> list = new ArrayList<GFAURLAlias>(1);
            list.add(new GFAURLAlias((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AU"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommand> getC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getC1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommand> getC1_3() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"C"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAWebCaptureCommand> list = new ArrayList<GFAWebCaptureCommand>(1);
            list.add(new GFAWebCaptureCommand((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "C"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AU"));
    }

    public COSObject getAUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AU"));
        return object;
    }

    public Boolean getAUHasTypeDictionary() {
        COSObject object = this.getAUValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getAUHasTypeStringAscii() {
        COSObject object = this.getAUValue();
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isASCIIString();
    }

    public Boolean getcontainsC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"C"));
    }

    public COSObject getCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"C"));
        return object;
    }

    public Boolean getisCIndirect() {
        COSObject object = this.getCValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getCHasTypeDictionary() {
        COSObject object = this.getCValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"E"));
    }

    public COSObject getEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"E"));
        return object;
    }

    public Boolean getEHasTypeDate() {
        COSObject object = this.getEValue();
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}(([Z+-]\\d\\d'(\\d\\d'?)?)?|Z)");
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct((long)0L);
            }
        }
        return null;
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        if (object == null || object.empty()) {
            object = this.getSDefaultValue();
        }
        return object;
    }

    public Boolean getSHasTypeInteger() {
        COSObject object = this.getSValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getSIntegerValue() {
        COSObject object = this.getSValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TS"));
    }

    public COSObject getTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TS"));
        return object;
    }

    public Boolean getTSHasTypeDate() {
        COSObject object = this.getTSValue();
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}(([Z+-]\\d\\d'(\\d\\d'?)?)?|Z)");
    }

    public String getparentSNameValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject S = this.parentObject.getKey(ASAtom.getASAtom((String)"S"));
        if (S != null && S.getType() == COSObjType.COS_NAME) {
            return S.getString();
        }
        return null;
    }
}

