/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStreamsGeneral;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStreamsGeneral;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AVRI;
import org.verapdf.model.baselayer.Object;

public class GFAVRI
extends GFAObject
implements AVRI {
    public GFAVRI(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AVRI");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CRL": {
                return this.getCRL();
            }
            case "Cert": {
                return this.getCert();
            }
            case "OCSP": {
                return this.getOCSP();
            }
            case "TS": {
                return this.getTS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStreamsGeneral> getCRL() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getCRL2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCRL2_0() {
        COSObject object = this.getCRLValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "CRL"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getCert2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert2_0() {
        COSObject object = this.getCertValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Cert"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getOCSP2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP2_0() {
        COSObject object = this.getOCSPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OCSP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getTS2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS2_0() {
        COSObject object = this.getTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "TS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCRL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CRL"));
    }

    public COSObject getCRLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CRL"));
        return object;
    }

    public Boolean getCRLHasTypeArray() {
        COSObject object = this.getCRLValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsCert() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Cert"));
    }

    public COSObject getCertValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Cert"));
        return object;
    }

    public Boolean getCertHasTypeArray() {
        COSObject object = this.getCertValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsOCSP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OCSP"));
    }

    public COSObject getOCSPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OCSP"));
        return object;
    }

    public Boolean getOCSPHasTypeArray() {
        COSObject object = this.getOCSPValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TS"));
    }

    public COSObject getTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TS"));
        return object;
    }

    public Boolean getisTSIndirect() {
        COSObject object = this.getTSValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getTSHasTypeStream() {
        COSObject object = this.getTSValue();
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }

    public Boolean getcontainsTU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TU"));
    }

    public COSObject getTUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TU"));
        return object;
    }

    public Boolean getTUHasTypeDate() {
        COSObject object = this.getTUValue();
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}(([Z+-]\\d\\d'(\\d\\d'?)?)?|Z)");
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Long getparentCRLsArraySize() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject CRLs = this.parentObject.getKey(ASAtom.getASAtom((String)"CRLs"));
        if (CRLs != null && CRLs.getType() == COSObjType.COS_ARRAY) {
            return (long)CRLs.size();
        }
        return null;
    }

    public Long getparentOCSPsArraySize() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject OCSPs = this.parentObject.getKey(ASAtom.getASAtom((String)"OCSPs"));
        if (OCSPs != null && OCSPs.getType() == COSObjType.COS_ARRAY) {
            return (long)OCSPs.size();
        }
        return null;
    }

    public Boolean getparentCRLsHasTypeArray() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject CRLs = this.parentObject.getKey(ASAtom.getASAtom((String)"CRLs"));
        return CRLs != null && CRLs.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getparentOCSPsHasTypeArray() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject OCSPs = this.parentObject.getKey(ASAtom.getASAtom((String)"OCSPs"));
        return OCSPs != null && OCSPs.getType() == COSObjType.COS_ARRAY;
    }
}

