/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfXRefIndexIntegers;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfXRefWIntegers;
import org.verapdf.gf.model.impl.arlington.GFAAuthCode;
import org.verapdf.gf.model.impl.arlington.GFACatalog;
import org.verapdf.gf.model.impl.arlington.GFADocInfo;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionPublicKey;
import org.verapdf.gf.model.impl.arlington.GFAEncryptionStandard;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFATrailerIDArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AArrayOfXRefIndexIntegers;
import org.verapdf.model.alayer.AArrayOfXRefWIntegers;
import org.verapdf.model.alayer.AAuthCode;
import org.verapdf.model.alayer.ACatalog;
import org.verapdf.model.alayer.ADocInfo;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.ATrailerIDArray;
import org.verapdf.model.alayer.AXRefStream;

public class GFAXRefStream
extends GFAObject
implements AXRefStream {
    public GFAXRefStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXRefStream");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AuthCode": {
                return this.getAuthCode();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "entryID": {
                return this.getentryID();
            }
            case "Index": {
                return this.getIndex();
            }
            case "Info": {
                return this.getInfo();
            }
            case "Root": {
                return this.getRoot();
            }
            case "W": {
                return this.getW();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AAuthCode> getAuthCode() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getAuthCode2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AAuthCode> getAuthCode2_0() {
        COSObject object = this.getAuthCodeValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAAuthCode> list = new ArrayList<GFAAuthCode>(1);
            list.add(new GFAAuthCode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AuthCode"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getEncrypt1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getEncrypt1_5() {
        COSObject object = this.getEncryptValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getEncryptDictionary1_5(object.getDirectBase(), "Encrypt");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getEncryptDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Adobe.PubSec": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "AdobePPKLite": {
                return new GFAEncryptionPublicKey(base, this.baseObject, keyName);
            }
            case "Standard": {
                return new GFAEncryptionStandard(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getF1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_5() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFFilter1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_5() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getFilter1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_5() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getentryID1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ATrailerIDArray> getentryID1_5() {
        COSObject object = this.getentryIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFATrailerIDArray> list = new ArrayList<GFATrailerIDArray>(1);
            list.add(new GFATrailerIDArray((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "ID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefIndexIntegers> getIndex() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getIndex1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefIndexIntegers> getIndex1_5() {
        COSObject object = this.getIndexValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfXRefIndexIntegers> list = new ArrayList<GFAArrayOfXRefIndexIntegers>(1);
            list.add(new GFAArrayOfXRefIndexIntegers((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Index"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getInfo1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ADocInfo> getInfo1_5() {
        COSObject object = this.getInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFADocInfo> list = new ArrayList<GFADocInfo>(1);
            list.add(new GFADocInfo((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Info"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getRoot1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<ACatalog> getRoot1_5() {
        COSObject object = this.getRootValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACatalog> list = new ArrayList<GFACatalog>(1);
            list.add(new GFACatalog((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Root"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefWIntegers> getW() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: {
                return this.getW1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfXRefWIntegers> getW1_5() {
        COSObject object = this.getWValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfXRefWIntegers> list = new ArrayList<GFAArrayOfXRefWIntegers>(1);
            list.add(new GFAArrayOfXRefWIntegers((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "W"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAuthCode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AuthCode"));
    }

    public COSObject getAuthCodeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AuthCode"));
        return object;
    }

    public Boolean getisAuthCodeIndirect() {
        COSObject object = this.getAuthCodeValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getAuthCodeHasTypeDictionary() {
        COSObject object = this.getAuthCodeValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public Boolean getDLHasTypeInteger() {
        COSObject object = this.getDLValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getDLIntegerValue() {
        COSObject object = this.getDLValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public Boolean getisDecodeParmsIndirect() {
        COSObject object = this.getDecodeParmsValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject object = this.getDecodeParmsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject object = this.getDecodeParmsValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Long getDecodeParmsArraySize() {
        COSObject object = this.getDecodeParmsValue();
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public Boolean getcontainsEncrypt() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Encrypt"));
    }

    public COSObject getEncryptValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        return object;
    }

    public Boolean getEncryptHasTypeDictionary() {
        COSObject object = this.getEncryptValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public Boolean getFHasTypeDictionary() {
        COSObject object = this.getFValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getFHasTypeString() {
        COSObject object = this.getFValue();
        return object != null && object.getType() == COSObjType.COS_STRING;
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject object = this.getFDecodeParmsValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject object = this.getFDecodeParmsValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Long getFDecodeParmsArraySize() {
        COSObject object = this.getFDecodeParmsValue();
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject object = this.getFFilterValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getFFilterHasTypeName() {
        COSObject object = this.getFFilterValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getFFilterNameValue() {
        COSObject object = this.getFFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Long getFFilterArraySize() {
        COSObject object = this.getFFilterValue();
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public Boolean getisFilterIndirect() {
        COSObject object = this.getFilterValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getFilterHasTypeArray() {
        COSObject object = this.getFilterValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getFilterHasTypeName() {
        COSObject object = this.getFilterValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getFilterNameValue() {
        COSObject object = this.getFilterValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Long getFilterArraySize() {
        COSObject object = this.getFilterValue();
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public String getFilterEntriesString() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return null;
        }
        if (object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        if (object.getType() != COSObjType.COS_ARRAY) {
            return null;
        }
        LinkedList<String> names = new LinkedList<String>();
        for (COSObject elem : (COSArray)object.getDirectBase()) {
            if (elem.getType() != COSObjType.COS_NAME) continue;
            names.add(elem.getString());
        }
        return String.join((CharSequence)"&", names);
    }

    public Boolean getcontainsID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"ID"));
    }

    public COSObject getentryIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"ID"));
        return object;
    }

    public Boolean getisentryIDIndirect() {
        COSObject object = this.getentryIDValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getentryIDHasTypeArray() {
        COSObject object = this.getentryIDValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getcontainsIndex() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Index"));
    }

    public COSObject getIndexValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Index"));
        return object;
    }

    public Boolean getisIndexIndirect() {
        COSObject object = this.getIndexValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getIndexHasTypeArray() {
        COSObject object = this.getIndexValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getisIndexArraySortAscending2() {
        COSObject object = this.getIndexValue();
        if (object == null || object.getType() != COSObjType.COS_ARRAY) {
            return false;
        }
        Long lastNumber = null;
        for (int i = 0; i < object.size(); i += 2) {
            COSObject elem = object.at(i);
            if (elem == null || elem.getType() != COSObjType.COS_INTEGER) {
                return false;
            }
            if (lastNumber != null && lastNumber > elem.getInteger()) {
                return false;
            }
            lastNumber = elem.getInteger();
        }
        return true;
    }

    public Long getIndexArraySize() {
        COSObject object = this.getIndexValue();
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (long)object.size();
        }
        return null;
    }

    public Boolean getcontainsInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Info"));
    }

    public COSObject getInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Info"));
        return object;
    }

    public Boolean getisInfoIndirect() {
        COSObject object = this.getInfoValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getInfoHasTypeDictionary() {
        COSObject object = this.getInfoValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject object = this.getLengthValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getLengthIntegerValue() {
        COSObject object = this.getLengthValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsPrev() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Prev"));
    }

    public COSObject getPrevValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Prev"));
        return object;
    }

    public Boolean getisPrevIndirect() {
        COSObject object = this.getPrevValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getPrevHasTypeInteger() {
        COSObject object = this.getPrevValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPrevIntegerValue() {
        COSObject object = this.getPrevValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsRoot() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Root"));
    }

    public COSObject getRootValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Root"));
        return object;
    }

    public Boolean getisRootIndirect() {
        COSObject object = this.getRootValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getRootHasTypeDictionary() {
        COSObject object = this.getRootValue();
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsSize() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Size"));
    }

    public COSObject getSizeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Size"));
        return object;
    }

    public Boolean getisSizeIndirect() {
        COSObject object = this.getSizeValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getSizeHasTypeInteger() {
        COSObject object = this.getSizeValue();
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getSizeIntegerValue() {
        COSObject object = this.getSizeValue();
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getisTypeIndirect() {
        COSObject object = this.getTypeValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.getTypeValue();
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.getTypeValue();
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public Boolean getcontainsW() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"W"));
    }

    public COSObject getWValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"W"));
        return object;
    }

    public Boolean getisWIndirect() {
        COSObject object = this.getWValue();
        return object != null && object.get() != null && object.get().isIndirect() != false;
    }

    public Boolean getWHasTypeArray() {
        COSObject object = this.getWValue();
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Long getEncryptVIntegerValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom((String)"V"));
        if (V != null && V.getType() == COSObjType.COS_INTEGER) {
            return V.getInteger();
        }
        return null;
    }

    public Boolean getEncryptVHasTypeInteger() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Encrypt = this.baseObject.getKey(ASAtom.getASAtom((String)"Encrypt"));
        if (Encrypt == null || !Encrypt.getType().isDictionaryBased()) {
            return null;
        }
        COSObject V = Encrypt.getKey(ASAtom.getASAtom((String)"V"));
        return V != null && V.getType() == COSObjType.COS_INTEGER;
    }

    public Boolean gethasExtensionISO_TS_32004() {
        return false;
    }
}

