/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.alayer.AObject;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDPage;
import org.verapdf.tools.StaticResources;

public class GFAObject
extends GenericModelObject
implements AObject {
    private static final List<String> standardFonts = new LinkedList<String>();
    private static final ThreadLocal<Set<COSKey>> keysSet = new ThreadLocal();
    protected static final String PDF_DATE_FORMAT_REGEX = "(D:)?(\\d\\d){2,7}(([Z+-]\\d\\d'(\\d\\d'?)?)?|Z)";
    protected final COSBase baseObject;
    protected COSBase parentObject;
    protected String keyName;

    public GFAObject(COSBase baseObject, COSBase parentObject, String objectType) {
        super(objectType);
        this.baseObject = baseObject;
        this.parentObject = parentObject;
    }

    public GFAObject(COSBase baseObject, COSBase parentObject, String keyName, String objectType) {
        this(baseObject, parentObject, objectType);
        this.keyName = keyName;
    }

    public String getID() {
        COSKey key = this.baseObject.getObjectKey();
        return key != null ? this.getObjectType() + " " + key.toString() : null;
    }

    public String getExtraContext() {
        return this.keyName == null || this.keyName.isEmpty() ? null : this.keyName;
    }

    public Long getsize() {
        return (long)this.baseObject.size();
    }

    public String getkeyName() {
        return this.keyName;
    }

    public String getkeysString() {
        return this.baseObject.getKeySet().stream().map(ASAtom::getValue).collect(Collectors.joining("&"));
    }

    public Long getnumberOfPages() {
        return StaticResources.getDocument().getPages().size();
    }

    public Long getfileSize() {
        return StaticResources.getDocument().getDocument().getFileSize();
    }

    public Boolean getisPDFTagged() {
        PDDocument document = StaticResources.getDocument();
        PDCatalog catalog = document.getCatalog();
        if (catalog == null) {
            return false;
        }
        COSObject markInfoObject = catalog.getKey(ASAtom.MARK_INFO);
        if (markInfoObject == null || markInfoObject.empty()) {
            return false;
        }
        COSBase markInfo = markInfoObject.getDirectBase();
        if (markInfo.getType() == COSObjType.COS_DICT) {
            return Objects.equals(markInfo.getBooleanKey(ASAtom.MARKED), true);
        }
        return false;
    }

    public Boolean getnotStandard14Font() {
        COSObject type = this.baseObject.getKey(ASAtom.TYPE);
        if (type == null || type.getType() != COSObjType.COS_NAME || type.getName() != ASAtom.FONT) {
            return false;
        }
        COSObject subtype = this.baseObject.getKey(ASAtom.SUBTYPE);
        if (subtype == null || subtype.getType() != COSObjType.COS_NAME || subtype.getName() != ASAtom.TYPE1) {
            return false;
        }
        COSObject baseFont = this.baseObject.getKey(ASAtom.BASE_FONT);
        if (baseFont == null || baseFont.getType() != COSObjType.COS_NAME) {
            return true;
        }
        return !standardFonts.contains(baseFont.getString());
    }

    public Boolean getisEncryptedWrapper() {
        PDDocument document = StaticResources.getDocument();
        if (document == null) {
            return false;
        }
        PDCatalog catalog = document.getCatalog();
        if (catalog == null) {
            return false;
        }
        PDNamesDictionary names = catalog.getNamesDictionary();
        if (names == null) {
            return false;
        }
        PDNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return false;
        }
        for (COSObject embeddedFile : embeddedFiles) {
            COSObject relationship = embeddedFile.getKey(ASAtom.AF_RELATIONSHIP);
            if (relationship == null || relationship.getType() != COSObjType.COS_NAME || relationship.getName() != ASAtom.getASAtom((String)"EncryptedPayload")) continue;
            return true;
        }
        return false;
    }

    public static Boolean hasCycle(COSObject object, ASAtom entryName) {
        if (object == null) {
            return false;
        }
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        while (object.knownKey(entryName).booleanValue()) {
            if (object.getKey() != null) {
                if (visitedKeys.contains(object.getKey())) {
                    return true;
                }
                visitedKeys.add(object.getKey());
            }
            object = object.getKey(entryName);
        }
        return false;
    }

    protected static COSObject getPageObject(COSObject object) {
        Long pageNumber = null;
        if (object != null && object.getType() == COSObjType.COS_STRING) {
            PDNamesDictionary names = StaticResources.getDocument().getCatalog().getNamesDictionary();
            if (names == null) {
                return null;
            }
            PDNameTreeNode dests = names.getDests();
            if (dests == null) {
                return null;
            }
            object = dests.getObject(object.getString());
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            pageNumber = object.getInteger();
        }
        if (pageNumber == null || pageNumber >= (long)StaticResources.getDocument().getPages().size()) {
            return null;
        }
        return ((PDPage)StaticResources.getDocument().getPages().get(pageNumber.intValue())).getObject();
    }

    public static Set<COSKey> getKeysSet() {
        if (keysSet.get() == null) {
            keysSet.set(new HashSet());
        }
        return keysSet.get();
    }

    public static void setKeysSet(Set<COSKey> keysSet) {
        GFAObject.keysSet.set(keysSet);
    }

    public static void clearAllContainers() {
        keysSet.set(new HashSet());
    }

    static {
        standardFonts.add("Times-Roman");
        standardFonts.add("Helvetica");
        standardFonts.add("Courier");
        standardFonts.add("Symbol");
        standardFonts.add("Times-Bold");
        standardFonts.add("Helvetica-Bold");
        standardFonts.add("Courier-Bold");
        standardFonts.add("ZapfDingbats");
        standardFonts.add("Times-Italic");
        standardFonts.add("Helvetica-Oblique");
        standardFonts.add("Courier-Oblique");
        standardFonts.add("Times-BoldItalic");
        standardFonts.add("Helvetica-BoldOblique");
        standardFonts.add("Courier-BoldOblique");
    }
}

