/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.*;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.model.tools.constants.Operators;
import org.verapdf.operator.Operator;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.parser.PDFStreamParser;
import org.verapdf.pd.structure.NameTreeIterator;
import java.io.IOException;

public class GFADPM extends GFAObject implements ADPM {

	public GFADPM(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ADPM");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "Entries":
				return getEntries();
			case "GTS_Managed":
				return getGTS_Managed();
			case "GTS_Suspect":
				return getGTS_Suspect();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<ADPMEntry> getEntries() {
		switch(StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getEntries1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<ADPMEntry> getEntries1_6() {
		List<ADPMEntry> list = new LinkedList<>();
		for (ASAtom key : baseObject.getKeySet()) {
			if ("GTS_Managed".equals(key.getValue()) || "GTS_Suspect".equals(key.getValue())) {
				continue;
			}
			COSObject object = this.baseObject.getKey(key);
			list.add(new GFADPMEntry(object != null ? object.get() : null, this.baseObject, keyName, key.getValue()));
		}
		return Collections.unmodifiableList(list);
	}

	private List<A_UniversalDictionary> getGTS_Managed() {
		switch(StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getGTS_Managed1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<A_UniversalDictionary> getGTS_Managed1_6() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GTS_Managed"));
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<A_UniversalDictionary> list = new ArrayList<>(1);
			list.add(new GFA_UniversalDictionary((COSDictionary)object.getDirectBase(), this.baseObject, "GTS_Managed"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<A_UniversalDictionary> getGTS_Suspect() {
		switch(StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getGTS_Suspect1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<A_UniversalDictionary> getGTS_Suspect1_6() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GTS_Suspect"));
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<A_UniversalDictionary> list = new ArrayList<>(1);
			list.add(new GFA_UniversalDictionary((COSDictionary)object.getDirectBase(), this.baseObject, "GTS_Suspect"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsGTS_Managed() {
		return this.baseObject.knownKey(ASAtom.getASAtom("GTS_Managed"));
	}

	@Override
	public Boolean getGTS_ManagedHasTypeDictionary() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GTS_Managed"));
		return object != null && object.getType() == COSObjType.COS_DICT;
	}

	@Override
	public Boolean getcontainsGTS_Suspect() {
		return this.baseObject.knownKey(ASAtom.getASAtom("GTS_Suspect"));
	}

	@Override
	public Boolean getGTS_SuspectHasTypeDictionary() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("GTS_Suspect"));
		return object != null && object.getType() == COSObjType.COS_DICT;
	}

}
