/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalArray;
import org.verapdf.gf.model.impl.arlington.GFA_UniversalDictionary;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ADPMEntry;
import org.verapdf.model.baselayer.Object;

public class GFADPMEntry
extends GFAObject
implements ADPMEntry {
    private String collectionName;

    public GFADPMEntry(COSBase baseObject, COSBase parentObject, String collectionName, String keyName) {
        super(baseObject, parentObject, keyName, "ADPMEntry");
        this.collectionName = collectionName;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entry": {
                return this.getEntry();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getEntry() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntry1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getEntry1_6() {
        COSObject object = new COSObject(this.baseObject);
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFA_UniversalArray> list = new ArrayList<GFA_UniversalArray>(1);
            list.add(new GFA_UniversalArray((COSBase)((COSArray)object.getDirectBase()), this.parentObject, this.keyName));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFA_UniversalDictionary> list = new ArrayList<GFA_UniversalDictionary>(1);
            list.add(new GFA_UniversalDictionary((COSBase)((COSDictionary)object.getDirectBase()), this.parentObject, this.keyName));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getHasTypeArray() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getHasTypeDate() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_STRING && object.getString().matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])");
    }

    public Boolean getHasTypeStringText() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_STRING && ((COSString)object.getDirectBase()).isTextString();
    }

    public Boolean getHasTypeBoolean() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_BOOLEAN;
    }

    public Boolean getHasTypeNumber() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType().isNumber();
    }

    public Boolean getHasTypeInteger() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Boolean getHasTypeName() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getHasTypeDictionary() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_DICT;
    }
}

