/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfRequirementsHandlers;
import org.verapdf.gf.model.impl.arlington.GFADocTimeStamp;
import org.verapdf.gf.model.impl.arlington.GFAExtensions;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFARequirementsHandler;
import org.verapdf.gf.model.impl.arlington.GFASignature;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AExtensions;
import org.verapdf.model.alayer.ARequirementsDigSigMDP;
import org.verapdf.model.baselayer.Object;

public class GFARequirementsDigSigMDP
extends GFAObject
implements ARequirementsDigSigMDP {
    public GFARequirementsDigSigMDP(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ARequirementsDigSigMDP");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "DigSig": {
                return this.getDigSig();
            }
            case "RH": {
                return this.getRH();
            }
            case "V": {
                return this.getV();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getDigSig() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getDigSig2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getDigSig2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigSig"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            Object result = this.getDigSigDictionary2_0(object.getDirectBase(), "DigSig");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getDigSigDictionary2_0(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Sig": {
                return new GFASignature(base, this.baseObject, keyName);
            }
            case "DocTimeStamp": {
                return new GFADocTimeStamp(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<Object> getRH() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getRH2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getRH2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RH"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfRequirementsHandlers> list = new ArrayList<GFAArrayOfRequirementsHandlers>(1);
            list.add(new GFAArrayOfRequirementsHandlers((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFARequirementsHandler> list = new ArrayList<GFARequirementsHandler>(1);
            list.add(new GFARequirementsHandler((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "RH"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return this.getV2_0();
            }
        }
        return Collections.emptyList();
    }

    private List<AExtensions> getV2_0() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAExtensions> list = new ArrayList<GFAExtensions>(1);
            list.add(new GFAExtensions((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "V"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsDigSig() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DigSig"));
    }

    public Boolean getDigSigHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DigSig"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsPenalty() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Penalty"));
    }

    public Boolean getPenaltyHasTypeInteger() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Penalty"));
        return object != null && object.getType() == COSObjType.COS_INTEGER;
    }

    public Long getPenaltyIntegerValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Penalty"));
        if (object == null || object.empty()) {
            return this.getPenaltyIntegerDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_INTEGER) {
            return object.getInteger();
        }
        return null;
    }

    public Long getPenaltyIntegerDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON2_0: {
                return 100L;
            }
        }
        return null;
    }

    public Boolean getcontainsRH() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"RH"));
    }

    public Boolean getRHHasTypeArray() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RH"));
        return object != null && object.getType() == COSObjType.COS_ARRAY;
    }

    public Boolean getRHHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"RH"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public Boolean getSHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getSNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        if (object == null || object.empty()) {
            return this.getSNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getSNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public Boolean getTypeHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public String getTypeNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        if (object == null || object.empty()) {
            return this.getTypeNameDefaultValue();
        }
        if (object != null && object.getType() == COSObjType.COS_NAME) {
            return object.getString();
        }
        return null;
    }

    public String getTypeNameDefaultValue() {
        return null;
    }

    public Boolean getcontainsV() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"V"));
    }

    public Boolean getVHasTypeName() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object != null && object.getType() == COSObjType.COS_NAME;
    }

    public Boolean getVHasTypeDictionary() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"V"));
        return object != null && object.getType() == COSObjType.COS_DICT;
    }
}

