/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAEmbeddedFileStream;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAXObjectImage;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASlideShowNameTreeResourcesEntry;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pd.PDNameTreeNode;

public class GFASlideShowNameTreeResourcesEntry
extends GFAObject
implements ASlideShowNameTreeResourcesEntry {
    private String collectionName;

    public GFASlideShowNameTreeResourcesEntry(COSBase baseObject, COSBase parentObject, String collectionName, String keyName) {
        super(baseObject, parentObject, keyName, "ASlideShowNameTreeResourcesEntry");
        this.collectionName = collectionName;
    }

    @Override
    public Long getsize() {
        return PDNameTreeNode.create((COSObject)new COSObject(this.baseObject)).size();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entry": {
                return this.getEntry();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getEntry() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntry1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getEntry1_4() {
        COSObject object = new COSObject(this.baseObject);
        if (object.getType() == COSObjType.COS_STREAM) {
            Object result = this.getEntryStream1_4(object.getDirectBase(), this.keyName);
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getEntryStream1_4(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return new GFAEmbeddedFileStream(base, this.baseObject, keyName);
        }
        switch (subtypeValue) {
            case "Image": {
                return new GFAXObjectImage(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getHasTypeStream() {
        COSObject object = new COSObject(this.baseObject);
        return object != null && object.getType() == COSObjType.COS_STREAM;
    }
}

