/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASubjectDNEntry;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASubjectDN;
import org.verapdf.model.alayer.ASubjectDNEntry;
import org.verapdf.model.baselayer.Object;

public class GFASubjectDN
extends GFAObject
implements ASubjectDN {
    public GFASubjectDN(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASubjectDN");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ASubjectDNEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<ASubjectDNEntry> getEntries1_7() {
        LinkedList<GFASubjectDNEntry> list = new LinkedList<GFASubjectDNEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFASubjectDNEntry(object != null ? object.get() : null, this.baseObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }
}

