/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFARichMediaSettings extends GFAObject implements ARichMediaSettings {

	public GFARichMediaSettings(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ARichMediaSettings");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "Activation":
				return getActivation();
			case "Deactivation":
				return getDeactivation();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<ARichMediaActivation> getActivation() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getActivation1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<ARichMediaActivation> getActivation1_7() {
		COSObject object = getActivationValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ARichMediaActivation> list = new ArrayList<>(1);
			list.add(new GFARichMediaActivation((COSDictionary)object.getDirectBase(), this.baseObject, "Activation"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<ARichMediaDeactivation> getDeactivation() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getDeactivation1_7();
			default:
				return Collections.emptyList();
		}
	}

	private List<ARichMediaDeactivation> getDeactivation1_7() {
		COSObject object = getDeactivationValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ARichMediaDeactivation> list = new ArrayList<>(1);
			list.add(new GFARichMediaDeactivation((COSDictionary)object.getDirectBase(), this.baseObject, "Deactivation"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsActivation() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Activation"));
	}

	public COSObject getActivationValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Activation"));
		return object;
	}

	@Override
	public Boolean getActivationHasTypeDictionary() {
		COSObject object = getActivationValue();
		return getHasTypeDictionary(object);
	}

	@Override
	public Boolean getcontainsDeactivation() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Deactivation"));
	}

	public COSObject getDeactivationValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Deactivation"));
		return object;
	}

	@Override
	public Boolean getDeactivationHasTypeDictionary() {
		COSObject object = getDeactivationValue();
		return getHasTypeDictionary(object);
	}

	@Override
	public Boolean getcontainsType() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Type"));
	}

	public COSObject getTypeValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Type"));
		return object;
	}

	@Override
	public Boolean getTypeHasTypeName() {
		COSObject object = getTypeValue();
		return getHasTypeName(object);
	}

	@Override
	public String getTypeNameValue() {
		COSObject object = getTypeValue();
		return getNameValue(object);
	}

	@Override
	public Boolean gethasExtensionADBE_Extn3() {
		return false;
	}

}
