/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACalGrayColorSpace;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AGroupAttributes;
import org.verapdf.model.baselayer.Object;

public class GFAGroupAttributes
extends GFAObject
implements AGroupAttributes {
    public GFAGroupAttributes(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AGroupAttributes");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CS": {
                return this.getCS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Object> getCS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCS1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> getCS1_4() {
        COSObject object = this.getCSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            Object result = this.getCSArray1_4(object.getDirectBase(), "CS");
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Object getCSArray1_4(COSBase base, String keyName) {
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    public Boolean getcontainsCS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CS"));
    }

    public COSObject getCSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CS"));
        return object;
    }

    public Boolean getCSHasTypeArray() {
        COSObject CS = this.getCSValue();
        return GFAGroupAttributes.getHasTypeArray(CS);
    }

    public Boolean getCSHasTypeName() {
        COSObject CS = this.getCSValue();
        return GFAGroupAttributes.getHasTypeName(CS);
    }

    public String getCSNameValue() {
        COSObject CS = this.getCSValue();
        return GFAGroupAttributes.getNameValue(CS);
    }

    public Boolean getcontainsI() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"I"));
    }

    public COSObject getIDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)false);
            }
        }
        return null;
    }

    public COSObject getIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"I"));
        if (object == null || object.empty()) {
            object = this.getIDefaultValue();
        }
        return object;
    }

    public Boolean getIHasTypeBoolean() {
        COSObject I = this.getIValue();
        return GFAGroupAttributes.getHasTypeBoolean(I);
    }

    public Boolean getcontainsK() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"K"));
    }

    public COSObject getKDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSBoolean.construct((boolean)false);
            }
        }
        return null;
    }

    public COSObject getKValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"K"));
        if (object == null || object.empty()) {
            object = this.getKDefaultValue();
        }
        return object;
    }

    public Boolean getKHasTypeBoolean() {
        COSObject K = this.getKValue();
        return GFAGroupAttributes.getHasTypeBoolean(K);
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        return object;
    }

    public Boolean getSHasTypeName() {
        COSObject S = this.getSValue();
        return GFAGroupAttributes.getHasTypeName(S);
    }

    public String getSNameValue() {
        COSObject S = this.getSValue();
        return GFAGroupAttributes.getNameValue(S);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAGroupAttributes.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAGroupAttributes.getNameValue(Type2);
    }
}

