/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFileSpecifications;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfIntegersGeneral;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAGroupAttributes;
import org.verapdf.gf.model.impl.arlington.GFAMeasureGEO;
import org.verapdf.gf.model.impl.arlington.GFAMeasureRL;
import org.verapdf.gf.model.impl.arlington.GFAMetadata;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion13;
import org.verapdf.gf.model.impl.arlington.GFAOPIVersion20;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAOptContentGroup;
import org.verapdf.gf.model.impl.arlington.GFAOptContentMembership;
import org.verapdf.gf.model.impl.arlington.GFAPagePiece;
import org.verapdf.gf.model.impl.arlington.GFAPointData;
import org.verapdf.gf.model.impl.arlington.GFAReference;
import org.verapdf.gf.model.impl.arlington.GFAResource;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.AArrayOfFileSpecifications;
import org.verapdf.model.alayer.AArrayOfIntegersGeneral;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AGroupAttributes;
import org.verapdf.model.alayer.AMetadata;
import org.verapdf.model.alayer.APagePiece;
import org.verapdf.model.alayer.APointData;
import org.verapdf.model.alayer.AReference;
import org.verapdf.model.alayer.AResource;
import org.verapdf.model.alayer.AXObjectFormType1;

public class GFAXObjectFormType1
extends GFAObject
implements AXObjectFormType1 {
    public GFAXObjectFormType1(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AXObjectFormType1");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AF": {
                return this.getAF();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "Group": {
                return this.getGroup();
            }
            case "Measure": {
                return this.getMeasure();
            }
            case "Metadata": {
                return this.getMetadata();
            }
            case "OC": {
                return this.getOC();
            }
            case "OPI": {
                return this.getOPI();
            }
            case "PieceInfo": {
                return this.getPieceInfo();
            }
            case "PtData": {
                return this.getPtData();
            }
            case "Ref": {
                return this.getRef();
            }
            case "Resources": {
                return this.getResources();
            }
            case "XUID": {
                return this.getXUID();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfFileSpecifications> getAF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionISO_19005_3().booleanValue()) {
                    return this.getAF1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getAF1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFileSpecifications> getAF1_7() {
        COSObject object = this.getAFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFileSpecifications> list = new ArrayList<GFAArrayOfFileSpecifications>(1);
            list.add(new GFAArrayOfFileSpecifications((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "AF"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: 
            case ARLINGTON1_1: {
                return this.getDecodeParms1_0();
            }
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getDecodeParms1_2();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_0() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFilterLZWDecode> list = new ArrayList<GFAFilterLZWDecode>(1);
            list.add(new GFAFilterLZWDecode((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_2() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_2(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_2(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getF1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_2() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_2();
            }
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_2() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_2(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_2(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getFFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_2() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        return this.getFilter1_0();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_0() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AGroupAttributes> getGroup() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getGroup1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AGroupAttributes> getGroup1_4() {
        COSObject object = this.getGroupValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAGroupAttributes> list = new ArrayList<GFAGroupAttributes>(1);
            list.add(new GFAGroupAttributes((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Group"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getMeasure1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getMeasure1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getMeasure1_7() {
        COSObject object = this.getMeasureValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getMeasureDictionary1_7(object.getDirectBase(), "Measure");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getMeasureDictionary1_7(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Subtype"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "GEO": {
                return new GFAMeasureGEO(base, this.baseObject, keyName);
            }
            case "RL": {
                return new GFAMeasureRL(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AMetadata> getMetadata() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getMetadata1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AMetadata> getMetadata1_4() {
        COSObject object = this.getMetadataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAMetadata> list = new ArrayList<GFAMetadata>(1);
            list.add(new GFAMetadata((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "Metadata"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getOC1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOC1_5() {
        COSObject object = this.getOCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOCDictionary1_5(object.getDirectBase(), "OC");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOCDictionary1_5(COSBase base, String keyName) {
        COSObject subtype = base.getKey(ASAtom.getASAtom((String)"Type"));
        if (subtype == null) {
            return null;
        }
        String subtypeValue = subtype.getString();
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "OCG": {
                return new GFAOptContentGroup(base, this.baseObject, keyName);
            }
            case "OCMD": {
                return new GFAOptContentMembership(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getOPI() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getOPI1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getOPI1_2() {
        COSObject object = this.getOPIValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getOPIDictionary1_2(object.getDirectBase(), "OPI");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getOPIDictionary1_2(COSBase base, String keyName) {
        if (base.knownKey(ASAtom.getASAtom((String)"1.3")).booleanValue()) {
            return new GFAOPIVersion13(base, this.baseObject, keyName);
        }
        if (base.knownKey(ASAtom.getASAtom((String)"2.0")).booleanValue()) {
            return new GFAOPIVersion20(base, this.baseObject, keyName);
        }
        return null;
    }

    private List<APagePiece> getPieceInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getPieceInfo1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<APagePiece> getPieceInfo1_3() {
        COSObject object = this.getPieceInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPagePiece> list = new ArrayList<GFAPagePiece>(1);
            list.add(new GFAPagePiece((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "PieceInfo"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionADBE_Extn3().booleanValue()) {
                    return this.getPtData1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getPtData1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<APointData> getPtData1_7() {
        COSObject object = this.getPtDataValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAPointData> list = new ArrayList<GFAPointData>(1);
            list.add(new GFAPointData((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "PtData"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AReference> getRef() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getRef1_4();
            }
        }
        return Collections.emptyList();
    }

    private List<AReference> getRef1_4() {
        COSObject object = this.getRefValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAReference> list = new ArrayList<GFAReference>(1);
            list.add(new GFAReference((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Ref"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AResource> getResources() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: {
                return this.getResources1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AResource> getResources1_2() {
        COSObject object = this.getResourcesValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAResource> list = new ArrayList<GFAResource>(1);
            list.add(new GFAResource((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "Resources"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfIntegersGeneral> getXUID() {
        return this.getXUID1_0();
    }

    private List<AArrayOfIntegersGeneral> getXUID1_0() {
        COSObject object = this.getXUIDValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfIntegersGeneral> list = new ArrayList<GFAArrayOfIntegersGeneral>(1);
            list.add(new GFAArrayOfIntegersGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "XUID"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AF"));
    }

    public COSObject getAFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AF"));
        return object;
    }

    public String getAFType() {
        COSObject AF = this.getAFValue();
        return this.getObjectType(AF);
    }

    public Boolean getAFHasTypeArray() {
        COSObject AF = this.getAFValue();
        return GFAXObjectFormType1.getHasTypeArray(AF);
    }

    public Boolean getcontainsBBox() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"BBox"));
    }

    public COSObject getBBoxValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"BBox"));
        return object;
    }

    public String getBBoxType() {
        COSObject BBox = this.getBBoxValue();
        return this.getObjectType(BBox);
    }

    public Boolean getBBoxHasTypeRectangle() {
        COSObject BBox = this.getBBoxValue();
        return GFAXObjectFormType1.getHasTypeRectangle(BBox);
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAXObjectFormType1.getHasTypeInteger(DL);
    }

    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAXObjectFormType1.getIntegerValue(DL);
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormType1.getHasTypeArray(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormType1.getHasTypeDictionary(DecodeParms);
    }

    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAXObjectFormType1.getArraySize(DecodeParms);
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAXObjectFormType1.getHasTypeDictionary(F);
    }

    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAXObjectFormType1.getHasTypeString(F);
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormType1.getHasTypeArray(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormType1.getHasTypeDictionary(FDecodeParms);
    }

    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAXObjectFormType1.getArraySize(FDecodeParms);
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormType1.getHasTypeArray(FFilter);
    }

    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormType1.getHasTypeName(FFilter);
    }

    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormType1.getNameValue(FFilter);
    }

    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAXObjectFormType1.getArraySize(FFilter);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormType1.getHasTypeArray(Filter2);
    }

    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormType1.getHasTypeName(Filter2);
    }

    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormType1.getNameValue(Filter2);
    }

    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAXObjectFormType1.getArraySize(Filter2);
    }

    public Boolean getcontainsFormType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FormType"));
    }

    public COSObject getFormTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FormType"));
        return object;
    }

    public String getFormTypeType() {
        COSObject FormType = this.getFormTypeValue();
        return this.getObjectType(FormType);
    }

    public Boolean getFormTypeHasTypeInteger() {
        COSObject FormType = this.getFormTypeValue();
        return GFAXObjectFormType1.getHasTypeInteger(FormType);
    }

    public Long getFormTypeIntegerValue() {
        COSObject FormType = this.getFormTypeValue();
        return GFAXObjectFormType1.getIntegerValue(FormType);
    }

    public Boolean getcontainsGTS_Encapsulated() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Encapsulated"));
    }

    public COSObject getGTS_EncapsulatedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Encapsulated"));
        return object;
    }

    public String getGTS_EncapsulatedType() {
        COSObject GTS_Encapsulated = this.getGTS_EncapsulatedValue();
        return this.getObjectType(GTS_Encapsulated);
    }

    public Boolean getGTS_EncapsulatedHasTypeBoolean() {
        COSObject GTS_Encapsulated = this.getGTS_EncapsulatedValue();
        return GFAXObjectFormType1.getHasTypeBoolean(GTS_Encapsulated);
    }

    public Boolean getcontainsGTS_Env() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Env"));
    }

    public COSObject getGTS_EnvValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Env"));
        return object;
    }

    public String getGTS_EnvType() {
        COSObject GTS_Env = this.getGTS_EnvValue();
        return this.getObjectType(GTS_Env);
    }

    public Boolean getGTS_EnvHasTypeStringText() {
        COSObject GTS_Env = this.getGTS_EnvValue();
        return GFAXObjectFormType1.getHasTypeStringText(GTS_Env);
    }

    public Boolean getcontainsGTS_Scope() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_Scope"));
    }

    public COSObject getGTS_ScopeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_Scope"));
        return object;
    }

    public String getGTS_ScopeType() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return this.getObjectType(GTS_Scope);
    }

    public Boolean getGTS_ScopeHasTypeName() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return GFAXObjectFormType1.getHasTypeName(GTS_Scope);
    }

    public String getGTS_ScopeNameValue() {
        COSObject GTS_Scope = this.getGTS_ScopeValue();
        return GFAXObjectFormType1.getNameValue(GTS_Scope);
    }

    public Boolean getcontainsGTS_XID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"GTS_XID"));
    }

    public COSObject getGTS_XIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"GTS_XID"));
        return object;
    }

    public String getGTS_XIDType() {
        COSObject GTS_XID = this.getGTS_XIDValue();
        return this.getObjectType(GTS_XID);
    }

    public Boolean getGTS_XIDHasTypeString() {
        COSObject GTS_XID = this.getGTS_XIDValue();
        return GFAXObjectFormType1.getHasTypeString(GTS_XID);
    }

    public Boolean getcontainsGroup() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Group"));
    }

    public COSObject getGroupValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Group"));
        return object;
    }

    public String getGroupType() {
        COSObject Group = this.getGroupValue();
        return this.getObjectType(Group);
    }

    public Boolean getGroupHasTypeDictionary() {
        COSObject Group = this.getGroupValue();
        return GFAXObjectFormType1.getHasTypeDictionary(Group);
    }

    public Boolean getcontainsLastModified() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"LastModified"));
    }

    public COSObject getLastModifiedValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"LastModified"));
        return object;
    }

    public String getLastModifiedType() {
        COSObject LastModified = this.getLastModifiedValue();
        return this.getObjectType(LastModified);
    }

    public Boolean getLastModifiedHasTypeDate() {
        COSObject LastModified = this.getLastModifiedValue();
        return GFAXObjectFormType1.getHasTypeDate(LastModified);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAXObjectFormType1.getHasTypeInteger(Length);
    }

    public Boolean getcontainsMatrix() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Matrix"));
    }

    public COSObject getMatrixDefaultValue() {
        return COSArray.construct((int)6, (double[])new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
    }

    public COSObject getMatrixValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Matrix"));
        if (object == null || object.empty()) {
            object = this.getMatrixDefaultValue();
        }
        return object;
    }

    public String getMatrixType() {
        COSObject Matrix = this.getMatrixValue();
        return this.getObjectType(Matrix);
    }

    public Boolean getMatrixHasTypeMatrix() {
        COSObject Matrix = this.getMatrixValue();
        return GFAXObjectFormType1.getHasTypeMatrix(Matrix);
    }

    public Boolean getcontainsMeasure() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Measure"));
    }

    public COSObject getMeasureValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Measure"));
        return object;
    }

    public String getMeasureType() {
        COSObject Measure = this.getMeasureValue();
        return this.getObjectType(Measure);
    }

    public Boolean getMeasureHasTypeDictionary() {
        COSObject Measure = this.getMeasureValue();
        return GFAXObjectFormType1.getHasTypeDictionary(Measure);
    }

    public Boolean getcontainsMetadata() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Metadata"));
    }

    public COSObject getMetadataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Metadata"));
        return object;
    }

    public Boolean getisMetadataIndirect() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectFormType1.getisIndirect(Metadata);
    }

    public String getMetadataType() {
        COSObject Metadata = this.getMetadataValue();
        return this.getObjectType(Metadata);
    }

    public Boolean getMetadataHasTypeStream() {
        COSObject Metadata = this.getMetadataValue();
        return GFAXObjectFormType1.getHasTypeStream(Metadata);
    }

    public Boolean getcontainsName() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Name"));
    }

    public COSObject getNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Name"));
        return object;
    }

    public String getNameType() {
        COSObject Name = this.getNameValue();
        return this.getObjectType(Name);
    }

    public Boolean getNameHasTypeName() {
        COSObject Name = this.getNameValue();
        return GFAXObjectFormType1.getHasTypeName(Name);
    }

    public Boolean getcontainsOC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OC"));
    }

    public COSObject getOCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OC"));
        return object;
    }

    public String getOCType() {
        COSObject OC = this.getOCValue();
        return this.getObjectType(OC);
    }

    public Boolean getOCHasTypeDictionary() {
        COSObject OC = this.getOCValue();
        return GFAXObjectFormType1.getHasTypeDictionary(OC);
    }

    public Boolean getcontainsOPI() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OPI"));
    }

    public COSObject getOPIValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OPI"));
        return object;
    }

    public String getOPIType() {
        COSObject OPI = this.getOPIValue();
        return this.getObjectType(OPI);
    }

    public Boolean getOPIHasTypeDictionary() {
        COSObject OPI = this.getOPIValue();
        return GFAXObjectFormType1.getHasTypeDictionary(OPI);
    }

    public Boolean getcontainsPieceInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PieceInfo"));
    }

    public COSObject getPieceInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PieceInfo"));
        return object;
    }

    public String getPieceInfoType() {
        COSObject PieceInfo = this.getPieceInfoValue();
        return this.getObjectType(PieceInfo);
    }

    public Boolean getPieceInfoHasTypeDictionary() {
        COSObject PieceInfo = this.getPieceInfoValue();
        return GFAXObjectFormType1.getHasTypeDictionary(PieceInfo);
    }

    public Boolean getcontainsPtData() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"PtData"));
    }

    public COSObject getPtDataValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"PtData"));
        return object;
    }

    public String getPtDataType() {
        COSObject PtData = this.getPtDataValue();
        return this.getObjectType(PtData);
    }

    public Boolean getPtDataHasTypeDictionary() {
        COSObject PtData = this.getPtDataValue();
        return GFAXObjectFormType1.getHasTypeDictionary(PtData);
    }

    public Boolean getcontainsRef() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Ref"));
    }

    public COSObject getRefValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Ref"));
        return object;
    }

    public String getRefType() {
        COSObject Ref = this.getRefValue();
        return this.getObjectType(Ref);
    }

    public Boolean getRefHasTypeDictionary() {
        COSObject Ref = this.getRefValue();
        return GFAXObjectFormType1.getHasTypeDictionary(Ref);
    }

    public Boolean getcontainsResources() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Resources"));
    }

    public COSObject getResourcesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Resources"));
        return object;
    }

    public String getResourcesType() {
        COSObject Resources = this.getResourcesValue();
        return this.getObjectType(Resources);
    }

    public Boolean getResourcesHasTypeDictionary() {
        COSObject Resources = this.getResourcesValue();
        return GFAXObjectFormType1.getHasTypeDictionary(Resources);
    }

    public Boolean getcontainsStructParent() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StructParent"));
    }

    public COSObject getStructParentValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StructParent"));
        return object;
    }

    public String getStructParentType() {
        COSObject StructParent = this.getStructParentValue();
        return this.getObjectType(StructParent);
    }

    public Boolean getStructParentHasTypeInteger() {
        COSObject StructParent = this.getStructParentValue();
        return GFAXObjectFormType1.getHasTypeInteger(StructParent);
    }

    public Boolean getcontainsStructParents() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"StructParents"));
    }

    public COSObject getStructParentsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"StructParents"));
        return object;
    }

    public String getStructParentsType() {
        COSObject StructParents = this.getStructParentsValue();
        return this.getObjectType(StructParents);
    }

    public Boolean getStructParentsHasTypeInteger() {
        COSObject StructParents = this.getStructParentsValue();
        return GFAXObjectFormType1.getHasTypeInteger(StructParents);
    }

    public Boolean getcontainsSubtype() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Subtype"));
    }

    public COSObject getSubtypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Subtype"));
        return object;
    }

    public String getSubtypeType() {
        COSObject Subtype = this.getSubtypeValue();
        return this.getObjectType(Subtype);
    }

    public Boolean getSubtypeHasTypeName() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectFormType1.getHasTypeName(Subtype);
    }

    public String getSubtypeNameValue() {
        COSObject Subtype = this.getSubtypeValue();
        return GFAXObjectFormType1.getNameValue(Subtype);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectFormType1.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAXObjectFormType1.getNameValue(Type2);
    }

    public Boolean getcontainsXUID() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"XUID"));
    }

    public COSObject getXUIDValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"XUID"));
        return object;
    }

    public String getXUIDType() {
        COSObject XUID = this.getXUIDValue();
        return this.getObjectType(XUID);
    }

    public Boolean getXUIDHasTypeArray() {
        COSObject XUID = this.getXUIDValue();
        return GFAXObjectFormType1.getHasTypeArray(XUID);
    }
}

