/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfStreamsGeneral;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfStreamsGeneral;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AVRI;
import org.verapdf.model.baselayer.Object;

public class GFAVRI
extends GFAObject
implements AVRI {
    public GFAVRI(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AVRI");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "CRL": {
                return this.getCRL();
            }
            case "Cert": {
                return this.getCert();
            }
            case "OCSP": {
                return this.getOCSP();
            }
            case "TS": {
                return this.getTS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfStreamsGeneral> getCRL() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCRL1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCRL1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCRL1_7() {
        COSObject object = this.getCRLValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "CRL"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getCert1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getCert1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getCert1_7() {
        COSObject object = this.getCertValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Cert"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getOCSP1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getOCSP1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfStreamsGeneral> getOCSP1_7() {
        COSObject object = this.getOCSPValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfStreamsGeneral> list = new ArrayList<GFAArrayOfStreamsGeneral>(1);
            list.add(new GFAArrayOfStreamsGeneral((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "OCSP"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_7: {
                if (this.gethasExtensionETSI_PAdES().booleanValue()) {
                    return this.getTS1_7();
                }
                return Collections.emptyList();
            }
            case ARLINGTON2_0: {
                return this.getTS1_7();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getTS1_7() {
        COSObject object = this.getTSValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "TS"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCRL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CRL"));
    }

    public COSObject getCRLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CRL"));
        return object;
    }

    public String getCRLType() {
        COSObject CRL = this.getCRLValue();
        return this.getObjectType(CRL);
    }

    public Boolean getCRLHasTypeArray() {
        COSObject CRL = this.getCRLValue();
        return GFAVRI.getHasTypeArray(CRL);
    }

    public Long getCRLArraySize() {
        COSObject CRL = this.getCRLValue();
        return GFAVRI.getArraySize(CRL);
    }

    public Boolean getcontainsCert() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Cert"));
    }

    public COSObject getCertValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Cert"));
        return object;
    }

    public String getCertType() {
        COSObject Cert = this.getCertValue();
        return this.getObjectType(Cert);
    }

    public Boolean getCertHasTypeArray() {
        COSObject Cert = this.getCertValue();
        return GFAVRI.getHasTypeArray(Cert);
    }

    public Long getCertArraySize() {
        COSObject Cert = this.getCertValue();
        return GFAVRI.getArraySize(Cert);
    }

    public Boolean getcontainsOCSP() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"OCSP"));
    }

    public COSObject getOCSPValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"OCSP"));
        return object;
    }

    public String getOCSPType() {
        COSObject OCSP = this.getOCSPValue();
        return this.getObjectType(OCSP);
    }

    public Boolean getOCSPHasTypeArray() {
        COSObject OCSP = this.getOCSPValue();
        return GFAVRI.getHasTypeArray(OCSP);
    }

    public Long getOCSPArraySize() {
        COSObject OCSP = this.getOCSPValue();
        return GFAVRI.getArraySize(OCSP);
    }

    public Boolean getcontainsTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TS"));
    }

    public COSObject getTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TS"));
        return object;
    }

    public Boolean getisTSIndirect() {
        COSObject TS = this.getTSValue();
        return GFAVRI.getisIndirect(TS);
    }

    public String getTSType() {
        COSObject TS = this.getTSValue();
        return this.getObjectType(TS);
    }

    public Boolean getTSHasTypeStream() {
        COSObject TS = this.getTSValue();
        return GFAVRI.getHasTypeStream(TS);
    }

    public Boolean getcontainsTU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TU"));
    }

    public COSObject getTUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TU"));
        return object;
    }

    public String getTUType() {
        COSObject TU = this.getTUValue();
        return this.getObjectType(TU);
    }

    public Boolean getTUHasTypeDate() {
        COSObject TU = this.getTUValue();
        return GFAVRI.getHasTypeDate(TU);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAVRI.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAVRI.getNameValue(Type2);
    }

    public COSObject getparentCRLsValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject CRLs = this.parentObject.getKey(ASAtom.getASAtom((String)"CRLs"));
        return CRLs;
    }

    public COSObject getparentOCSPsValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject OCSPs = this.parentObject.getKey(ASAtom.getASAtom((String)"OCSPs"));
        return OCSPs;
    }

    public Long getparentCRLsArraySize() {
        COSObject parentCRLs = this.getparentCRLsValue();
        return GFAVRI.getArraySize(parentCRLs);
    }

    public Long getparentOCSPsArraySize() {
        COSObject parentOCSPs = this.getparentOCSPsValue();
        return GFAVRI.getArraySize(parentOCSPs);
    }

    public Boolean getparentCRLsHasTypeArray() {
        COSObject parentCRLs = this.getparentCRLsValue();
        return GFAVRI.getHasTypeArray(parentCRLs);
    }

    public Boolean getparentOCSPsHasTypeArray() {
        COSObject parentOCSPs = this.getparentOCSPsValue();
        return GFAVRI.getHasTypeArray(parentOCSPs);
    }
}

