/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAURLAlias;
import org.verapdf.gf.model.impl.arlington.GFAWebCaptureCommand;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.ASourceInformation;
import org.verapdf.model.alayer.AURLAlias;
import org.verapdf.model.alayer.AWebCaptureCommand;
import org.verapdf.model.baselayer.Object;

public class GFASourceInformation
extends GFAObject
implements ASourceInformation {
    public GFASourceInformation(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "ASourceInformation");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "AU": {
                return this.getAU();
            }
            case "C": {
                return this.getC();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AURLAlias> getAU() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getAU1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AURLAlias> getAU1_3() {
        COSObject object = this.getAUValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAURLAlias> list = new ArrayList<GFAURLAlias>(1);
            list.add(new GFAURLAlias((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "AU"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommand> getC() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getC1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AWebCaptureCommand> getC1_3() {
        COSObject object = this.getCValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAWebCaptureCommand> list = new ArrayList<GFAWebCaptureCommand>(1);
            list.add(new GFAWebCaptureCommand((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "C"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAU() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"AU"));
    }

    public COSObject getAUValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"AU"));
        return object;
    }

    public String getAUType() {
        COSObject AU = this.getAUValue();
        return this.getObjectType(AU);
    }

    public Boolean getAUHasTypeDictionary() {
        COSObject AU = this.getAUValue();
        return GFASourceInformation.getHasTypeDictionary(AU);
    }

    public Boolean getAUHasTypeStringAscii() {
        COSObject AU = this.getAUValue();
        return GFASourceInformation.getHasTypeStringAscii(AU);
    }

    public Boolean getcontainsC() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"C"));
    }

    public COSObject getCValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"C"));
        return object;
    }

    public Boolean getisCIndirect() {
        COSObject C = this.getCValue();
        return GFASourceInformation.getisIndirect(C);
    }

    public String getCType() {
        COSObject C = this.getCValue();
        return this.getObjectType(C);
    }

    public Boolean getCHasTypeDictionary() {
        COSObject C = this.getCValue();
        return GFASourceInformation.getHasTypeDictionary(C);
    }

    public Boolean getcontainsE() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"E"));
    }

    public COSObject getEValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"E"));
        return object;
    }

    public String getEType() {
        COSObject E = this.getEValue();
        return this.getObjectType(E);
    }

    public Boolean getEHasTypeDate() {
        COSObject E = this.getEValue();
        return GFASourceInformation.getHasTypeDate(E);
    }

    public Boolean getcontainsS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"S"));
    }

    public COSObject getSDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct((long)0L);
            }
        }
        return null;
    }

    public COSObject getSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"S"));
        if (object == null || object.empty()) {
            object = this.getSDefaultValue();
        }
        return object;
    }

    public String getSType() {
        COSObject S = this.getSValue();
        return this.getObjectType(S);
    }

    public Boolean getSHasTypeInteger() {
        COSObject S = this.getSValue();
        return GFASourceInformation.getHasTypeInteger(S);
    }

    public Long getSIntegerValue() {
        COSObject S = this.getSValue();
        return GFASourceInformation.getIntegerValue(S);
    }

    public Boolean getcontainsTS() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"TS"));
    }

    public COSObject getTSValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"TS"));
        return object;
    }

    public String getTSType() {
        COSObject TS = this.getTSValue();
        return this.getObjectType(TS);
    }

    public Boolean getTSHasTypeDate() {
        COSObject TS = this.getTSValue();
        return GFASourceInformation.getHasTypeDate(TS);
    }

    public COSObject getparentSValue() {
        if (this.parentObject == null || !this.parentObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject S = this.parentObject.getKey(ASAtom.getASAtom((String)"S"));
        return S;
    }

    public String getparentSNameValue() {
        COSObject parentS = this.getparentSValue();
        return GFASourceInformation.getNameValue(parentS);
    }
}

