/**
 * This file is part of veraPDF Validation for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.arlington;

import org.verapdf.cos.*;
import org.verapdf.model.alayer.*;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.tools.StaticResources;
import java.util.*;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.as.ASAtom;
import java.util.stream.Collectors;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class GFADeviceNMixingHints extends GFAObject implements ADeviceNMixingHints {

	public GFADeviceNMixingHints(COSBase baseObject, COSBase parentObject, String keyName) {
		super(baseObject, parentObject, keyName, "ADeviceNMixingHints");
	}

	@Override
	public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
		switch (link) {
			case "DotGain":
				return getDotGain();
			case "PrintingOrder":
				return getPrintingOrder();
			case "Solidities":
				return getSolidities();
			default:
				return super.getLinkedObjects(link);
		}
	}

	private List<ADictionaryOfFunctions> getDotGain() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getDotGain1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<ADictionaryOfFunctions> getDotGain1_6() {
		COSObject object = getDotGainValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ADictionaryOfFunctions> list = new ArrayList<>(1);
			list.add(new GFADictionaryOfFunctions((COSDictionary)object.getDirectBase(), this.baseObject, "DotGain"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<AArrayOfNamesForPrintingOrder> getPrintingOrder() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getPrintingOrder1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<AArrayOfNamesForPrintingOrder> getPrintingOrder1_6() {
		COSObject object = getPrintingOrderValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_ARRAY) {
			List<AArrayOfNamesForPrintingOrder> list = new ArrayList<>(1);
			list.add(new GFAArrayOfNamesForPrintingOrder((COSArray)object.getDirectBase(), this.baseObject, "PrintingOrder"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	private List<ASolidities> getSolidities() {
		switch (StaticContainers.getFlavour()) {
			case ARLINGTON1_6:
			case ARLINGTON1_7:
			case ARLINGTON2_0:
				return getSolidities1_6();
			default:
				return Collections.emptyList();
		}
	}

	private List<ASolidities> getSolidities1_6() {
		COSObject object = getSoliditiesValue();
		if (object == null) {
			return Collections.emptyList();
		}
		if (object.getType() == COSObjType.COS_DICT) {
			List<ASolidities> list = new ArrayList<>(1);
			list.add(new GFASolidities((COSDictionary)object.getDirectBase(), this.baseObject, "Solidities"));
			return Collections.unmodifiableList(list);
		}
		return Collections.emptyList();
	}

	@Override
	public Boolean getcontainsDotGain() {
		return this.baseObject.knownKey(ASAtom.getASAtom("DotGain"));
	}

	public COSObject getDotGainValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DotGain"));
		return object;
	}

	@Override
	public String getDotGainType() {
		COSObject DotGain = getDotGainValue();
		return getObjectType(DotGain);
	}

	@Override
	public Boolean getDotGainHasTypeDictionary() {
		COSObject DotGain = getDotGainValue();
		return getHasTypeDictionary(DotGain);
	}

	@Override
	public Boolean getcontainsPrintingOrder() {
		return this.baseObject.knownKey(ASAtom.getASAtom("PrintingOrder"));
	}

	public COSObject getPrintingOrderValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("PrintingOrder"));
		return object;
	}

	@Override
	public String getPrintingOrderType() {
		COSObject PrintingOrder = getPrintingOrderValue();
		return getObjectType(PrintingOrder);
	}

	@Override
	public Boolean getPrintingOrderHasTypeArray() {
		COSObject PrintingOrder = getPrintingOrderValue();
		return getHasTypeArray(PrintingOrder);
	}

	@Override
	public Boolean getcontainsSolidities() {
		return this.baseObject.knownKey(ASAtom.getASAtom("Solidities"));
	}

	public COSObject getSoliditiesValue() {
		COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Solidities"));
		return object;
	}

	@Override
	public String getSoliditiesType() {
		COSObject Solidities = getSoliditiesValue();
		return getObjectType(Solidities);
	}

	@Override
	public Boolean getSoliditiesHasTypeDictionary() {
		COSObject Solidities = getSoliditiesValue();
		return getHasTypeDictionary(Solidities);
	}

}
