/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfCompressionFilterNames;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfDecodeParams;
import org.verapdf.gf.model.impl.arlington.GFACIDSystemInfo;
import org.verapdf.gf.model.impl.arlington.GFAFileSpecification;
import org.verapdf.gf.model.impl.arlington.GFAFilterCrypt;
import org.verapdf.gf.model.impl.arlington.GFAFilterFlateDecode;
import org.verapdf.gf.model.impl.arlington.GFAFilterLZWDecode;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfCompressionFilterNames;
import org.verapdf.model.alayer.ACIDSystemInfo;
import org.verapdf.model.alayer.AFileSpecification;
import org.verapdf.model.alayer.AStream;
import org.verapdf.model.alayer.AToUnicodeCMapStream;

public class GFAToUnicodeCMapStream
extends GFAObject
implements AToUnicodeCMapStream {
    public GFAToUnicodeCMapStream(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AToUnicodeCMapStream");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "CIDSystemInfo": {
                return this.getCIDSystemInfo();
            }
            case "DecodeParms": {
                return this.getDecodeParms();
            }
            case "F": {
                return this.getF();
            }
            case "FDecodeParms": {
                return this.getFDecodeParms();
            }
            case "FFilter": {
                return this.getFFilter();
            }
            case "Filter": {
                return this.getFilter();
            }
            case "UseCMap": {
                return this.getUseCMap();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ACIDSystemInfo> getCIDSystemInfo() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCIDSystemInfo1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<ACIDSystemInfo> getCIDSystemInfo1_2() {
        COSObject object = this.getCIDSystemInfoValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFACIDSystemInfo> list = new ArrayList<GFACIDSystemInfo>(1);
            list.add(new GFACIDSystemInfo((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "CIDSystemInfo"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getDecodeParms1_2();
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_2() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_2(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_2(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDecodeParms1_5() {
        COSObject object = this.getDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "DecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getDecodeParmsDictionary1_5(object.getDirectBase(), "DecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDecodeParmsDictionary1_5(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AFileSpecification> getF() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getF1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AFileSpecification> getF1_2() {
        COSObject object = this.getFValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAFileSpecification> list = new ArrayList<GFAFileSpecification>(1);
            list.add(new GFAFileSpecification((COSBase)((COSDictionary)object.getDirectBase()), this.baseObject, "F"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: {
                return this.getFDecodeParms1_2();
            }
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFDecodeParms1_5();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_2() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_2(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_2(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getFDecodeParms1_5() {
        COSObject object = this.getFDecodeParmsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfDecodeParams> list = new ArrayList<GFAArrayOfDecodeParams>(1);
            list.add(new GFAArrayOfDecodeParams((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FDecodeParms"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_DICT) {
            org.verapdf.model.baselayer.Object result = this.getFDecodeParmsDictionary1_5(object.getDirectBase(), "FDecodeParms");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getFDecodeParmsDictionary1_5(COSBase base, String keyName) {
        String subtypeValue;
        COSObject subtype = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "Crypt": {
                return new GFAFilterCrypt(base, this.baseObject, keyName);
            }
            case "FlateDecode": {
                return new GFAFilterFlateDecode(base, this.baseObject, keyName);
            }
            case "LZWDecode": {
                return new GFAFilterLZWDecode(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<AArrayOfCompressionFilterNames> getFFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFFilter1_2() {
        COSObject object = this.getFFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "FFilter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getFilter1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfCompressionFilterNames> getFilter1_2() {
        COSObject object = this.getFilterValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfCompressionFilterNames> list = new ArrayList<GFAArrayOfCompressionFilterNames>(1);
            list.add(new GFAArrayOfCompressionFilterNames((COSBase)((COSArray)object.getDirectBase()), this.baseObject, "Filter"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AStream> getUseCMap() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getUseCMap1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AStream> getUseCMap1_2() {
        COSObject object = this.getUseCMapValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSBase)((COSStream)object.getDirectBase()), this.baseObject, "UseCMap"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsCIDSystemInfo() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CIDSystemInfo"));
    }

    public COSObject getCIDSystemInfoValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CIDSystemInfo"));
        return object;
    }

    public String getCIDSystemInfoType() {
        COSObject CIDSystemInfo = this.getCIDSystemInfoValue();
        return this.getObjectType(CIDSystemInfo);
    }

    public Boolean getCIDSystemInfoHasTypeDictionary() {
        COSObject CIDSystemInfo = this.getCIDSystemInfoValue();
        return GFAToUnicodeCMapStream.getHasTypeDictionary(CIDSystemInfo);
    }

    public Boolean getcontainsCMapName() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"CMapName"));
    }

    public COSObject getCMapNameValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"CMapName"));
        return object;
    }

    public String getCMapNameType() {
        COSObject CMapName = this.getCMapNameValue();
        return this.getObjectType(CMapName);
    }

    public Boolean getCMapNameHasTypeName() {
        COSObject CMapName = this.getCMapNameValue();
        return GFAToUnicodeCMapStream.getHasTypeName(CMapName);
    }

    public Boolean getcontainsDL() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DL"));
    }

    public COSObject getDLValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DL"));
        return object;
    }

    public String getDLType() {
        COSObject DL = this.getDLValue();
        return this.getObjectType(DL);
    }

    public Boolean getDLHasTypeInteger() {
        COSObject DL = this.getDLValue();
        return GFAToUnicodeCMapStream.getHasTypeInteger(DL);
    }

    public Long getDLIntegerValue() {
        COSObject DL = this.getDLValue();
        return GFAToUnicodeCMapStream.getIntegerValue(DL);
    }

    public Boolean getcontainsDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"DecodeParms"));
    }

    public COSObject getDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"DecodeParms"));
        return object;
    }

    public String getDecodeParmsType() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return this.getObjectType(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeArray() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAToUnicodeCMapStream.getHasTypeArray(DecodeParms);
    }

    public Boolean getDecodeParmsHasTypeDictionary() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAToUnicodeCMapStream.getHasTypeDictionary(DecodeParms);
    }

    public Long getDecodeParmsArraySize() {
        COSObject DecodeParms = this.getDecodeParmsValue();
        return GFAToUnicodeCMapStream.getArraySize(DecodeParms);
    }

    public Boolean getcontainsF() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"F"));
    }

    public COSObject getFValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"F"));
        return object;
    }

    public String getFType() {
        COSObject F = this.getFValue();
        return this.getObjectType(F);
    }

    public Boolean getFHasTypeDictionary() {
        COSObject F = this.getFValue();
        return GFAToUnicodeCMapStream.getHasTypeDictionary(F);
    }

    public Boolean getFHasTypeString() {
        COSObject F = this.getFValue();
        return GFAToUnicodeCMapStream.getHasTypeString(F);
    }

    public Boolean getcontainsFDecodeParms() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FDecodeParms"));
    }

    public COSObject getFDecodeParmsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FDecodeParms"));
        return object;
    }

    public String getFDecodeParmsType() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return this.getObjectType(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeArray() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAToUnicodeCMapStream.getHasTypeArray(FDecodeParms);
    }

    public Boolean getFDecodeParmsHasTypeDictionary() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAToUnicodeCMapStream.getHasTypeDictionary(FDecodeParms);
    }

    public Long getFDecodeParmsArraySize() {
        COSObject FDecodeParms = this.getFDecodeParmsValue();
        return GFAToUnicodeCMapStream.getArraySize(FDecodeParms);
    }

    public Boolean getcontainsFFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"FFilter"));
    }

    public COSObject getFFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"FFilter"));
        return object;
    }

    public String getFFilterType() {
        COSObject FFilter = this.getFFilterValue();
        return this.getObjectType(FFilter);
    }

    public Boolean getFFilterHasTypeArray() {
        COSObject FFilter = this.getFFilterValue();
        return GFAToUnicodeCMapStream.getHasTypeArray(FFilter);
    }

    public Boolean getFFilterHasTypeName() {
        COSObject FFilter = this.getFFilterValue();
        return GFAToUnicodeCMapStream.getHasTypeName(FFilter);
    }

    public String getFFilterNameValue() {
        COSObject FFilter = this.getFFilterValue();
        return GFAToUnicodeCMapStream.getNameValue(FFilter);
    }

    public Long getFFilterArraySize() {
        COSObject FFilter = this.getFFilterValue();
        return GFAToUnicodeCMapStream.getArraySize(FFilter);
    }

    public Boolean getcontainsFilter() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Filter"));
    }

    public COSObject getFilterValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Filter"));
        return object;
    }

    public String getFilterType() {
        COSObject Filter2 = this.getFilterValue();
        return this.getObjectType(Filter2);
    }

    public Boolean getFilterHasTypeArray() {
        COSObject Filter2 = this.getFilterValue();
        return GFAToUnicodeCMapStream.getHasTypeArray(Filter2);
    }

    public Boolean getFilterHasTypeName() {
        COSObject Filter2 = this.getFilterValue();
        return GFAToUnicodeCMapStream.getHasTypeName(Filter2);
    }

    public String getFilterNameValue() {
        COSObject Filter2 = this.getFilterValue();
        return GFAToUnicodeCMapStream.getNameValue(Filter2);
    }

    public Long getFilterArraySize() {
        COSObject Filter2 = this.getFilterValue();
        return GFAToUnicodeCMapStream.getArraySize(Filter2);
    }

    public Boolean getcontainsLength() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Length"));
    }

    public COSObject getLengthValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Length"));
        return object;
    }

    public String getLengthType() {
        COSObject Length = this.getLengthValue();
        return this.getObjectType(Length);
    }

    public Boolean getLengthHasTypeInteger() {
        COSObject Length = this.getLengthValue();
        return GFAToUnicodeCMapStream.getHasTypeInteger(Length);
    }

    public Boolean getcontainsType() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"Type"));
    }

    public COSObject getTypeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"Type"));
        return object;
    }

    public String getTypeType() {
        COSObject Type2 = this.getTypeValue();
        return this.getObjectType(Type2);
    }

    public Boolean getTypeHasTypeName() {
        COSObject Type2 = this.getTypeValue();
        return GFAToUnicodeCMapStream.getHasTypeName(Type2);
    }

    public String getTypeNameValue() {
        COSObject Type2 = this.getTypeValue();
        return GFAToUnicodeCMapStream.getNameValue(Type2);
    }

    public Boolean getcontainsUseCMap() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"UseCMap"));
    }

    public COSObject getUseCMapValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"UseCMap"));
        return object;
    }

    public Boolean getisUseCMapIndirect() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFAToUnicodeCMapStream.getisIndirect(UseCMap);
    }

    public String getUseCMapType() {
        COSObject UseCMap = this.getUseCMapValue();
        return this.getObjectType(UseCMap);
    }

    public Boolean getUseCMapHasTypeName() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFAToUnicodeCMapStream.getHasTypeName(UseCMap);
    }

    public Boolean getUseCMapHasTypeStream() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFAToUnicodeCMapStream.getHasTypeStream(UseCMap);
    }

    public String getUseCMapNameValue() {
        COSObject UseCMap = this.getUseCMapValue();
        return GFAToUnicodeCMapStream.getNameValue(UseCMap);
    }

    public Boolean getcontainsWMode() {
        return this.baseObject.knownKey(ASAtom.getASAtom((String)"WMode"));
    }

    public COSObject getWModeDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_2: 
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct((long)0L);
            }
        }
        return null;
    }

    public COSObject getWModeValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom((String)"WMode"));
        if (object == null || object.empty()) {
            object = this.getWModeDefaultValue();
        }
        return object;
    }

    public String getWModeType() {
        COSObject WMode = this.getWModeValue();
        return this.getObjectType(WMode);
    }

    public Boolean getWModeHasTypeInteger() {
        COSObject WMode = this.getWModeValue();
        return GFAToUnicodeCMapStream.getHasTypeInteger(WMode);
    }

    public Long getWModeIntegerValue() {
        COSObject WMode = this.getWModeValue();
        return GFAToUnicodeCMapStream.getIntegerValue(WMode);
    }
}

