/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSHeader;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosFileSpecification;
import org.verapdf.gf.model.impl.cos.GFCosIndirect;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.impl.cos.GFCosTrailer;
import org.verapdf.gf.model.impl.cos.GFCosXRef;
import org.verapdf.gf.model.impl.pd.GFPDDocument;
import org.verapdf.gf.model.impl.sa.GFSAPDFDocument;
import org.verapdf.gf.model.tools.FileSpecificationKeysHelper;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.coslayer.CosFileSpecification;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.model.coslayer.CosXRef;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.salayer.SAPDFDocument;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.tools.StaticResources;

public class GFCosDocument
extends GFCosObject
implements CosDocument {
    private static final Logger LOGGER = Logger.getLogger(GFCosDocument.class.getCanonicalName());
    public static final String COS_DOCUMENT_TYPE = "CosDocument";
    private static final String TRAILER = "trailer";
    private static final String XREF = "xref";
    private static final String INDIRECT_OBJECTS = "indirectObjects";
    private static final String DOCUMENT = "document";
    private static final String DOC = "doc";
    private static final String EMBEDDED_FILES = "EmbeddedFiles";
    private static final String GFSAPDFDOCUMENT_CLASS_NAME = "org.verapdf.gf.model.impl.sa.GFSAPDFDocument";
    private final COSDictionary catalog = this.getCatalog();
    private final long indirectObjectCount;
    private final float headerVersion;
    private final long headerOffset;
    private final String header;
    private final int headerCommentByte1;
    private final int headerCommentByte2;
    private final int headerCommentByte3;
    private final int headerCommentByte4;
    private final boolean isOptionalContentPresent;
    private final int postEOFDataSize;
    private final boolean isLinearised;
    private final String firstPageID;
    private final String lastID;

    public GFCosDocument(COSDocument cosDocument) {
        super(cosDocument, COS_DOCUMENT_TYPE);
        COSHeader cosHeader = cosDocument.getHeader();
        this.indirectObjectCount = cosDocument.getObjects().size();
        this.headerVersion = cosHeader.getVersion();
        this.headerOffset = cosHeader.getHeaderOffset();
        this.header = cosHeader.getHeader();
        this.headerCommentByte1 = cosHeader.getHeaderCommentByte1();
        this.headerCommentByte2 = cosHeader.getHeaderCommentByte2();
        this.headerCommentByte3 = cosHeader.getHeaderCommentByte3();
        this.headerCommentByte4 = cosHeader.getHeaderCommentByte4();
        this.isOptionalContentPresent = this.parseOptionalContentPresent();
        this.postEOFDataSize = cosDocument.getPostEOFDataSize();
        this.isLinearised = cosDocument.getTrailer() != cosDocument.getLastTrailer() && cosDocument.isLinearized();
        this.lastID = GFCosDocument.getTrailerID(cosDocument.getLastTrailer().getKey(ASAtom.ID));
        this.firstPageID = GFCosDocument.getTrailerID(cosDocument.getFirstTrailer().getKey(ASAtom.ID));
        if (PDFFlavours.isFlavourPart((PDFAFlavour)StaticContainers.getFlavour(), (PDFAFlavour.Specification)PDFAFlavour.Specification.ISO_19005_3)) {
            FileSpecificationKeysHelper.registerFileSpecificationKeys(cosDocument);
        }
    }

    private boolean parseOptionalContentPresent() {
        return this.catalog != null && !this.catalog.getKey(ASAtom.OCPROPERTIES).empty();
    }

    public Long getnrIndirects() {
        return this.indirectObjectCount;
    }

    public Double getheaderVersion() {
        return this.headerVersion;
    }

    public Long getheaderOffset() {
        return this.headerOffset;
    }

    public String getheader() {
        return this.header;
    }

    public Long getheaderByte1() {
        return this.headerCommentByte1;
    }

    public Long getheaderByte2() {
        return this.headerCommentByte2;
    }

    public Long getheaderByte3() {
        return this.headerCommentByte3;
    }

    public Long getheaderByte4() {
        return this.headerCommentByte4;
    }

    public Boolean getisOptionalContentPresent() {
        return this.isOptionalContentPresent;
    }

    public Long getpostEOFDataSize() {
        return this.postEOFDataSize;
    }

    public String getfirstPageID() {
        return this.firstPageID;
    }

    public String getlastID() {
        if (PDFFlavours.isFlavourPart((PDFAFlavour)StaticContainers.getFlavour(), (PDFAFlavour.Specification)PDFAFlavour.Specification.ISO_19005_1)) {
            return this.lastID;
        }
        if (this.isLinearised) {
            return this.firstPageID;
        }
        return this.lastID;
    }

    public String getfirstPageIDValue() {
        COSObject id = this.cosDocument.getFirstTrailer().getKey(ASAtom.ID);
        return id != null ? id.toString() : null;
    }

    public String getlastIDValue() {
        COSObject id = this.cosDocument.getLastTrailer().getKey(ASAtom.ID);
        return id != null ? id.toString() : null;
    }

    private static String getTrailerID(COSObject ids) {
        if (ids != null && ids.getType() == COSObjType.COS_ARRAY) {
            COSArray idArray = (COSArray)ids.getDirectBase();
            if (idArray.size() != 2) {
                LOGGER.log(Level.WARNING, "Value of ID is not an array of two byte strings");
            }
            StringBuilder builder = new StringBuilder();
            for (COSObject id : idArray) {
                if (id.getType() == COSObjType.COS_STRING) {
                    for (byte aByte : ((COSString)id.getDirectBase()).get()) {
                        builder.append((char)(aByte & 0xFF));
                    }
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Value of ID key is not a string. Ignoring ID");
            }
            return builder.toString();
        }
        return null;
    }

    public Boolean getisLinearized() {
        return this.isLinearised;
    }

    public Boolean getMarked() {
        if (this.catalog != null) {
            COSObject markInfoObject = this.catalog.getKey(ASAtom.MARK_INFO);
            if (markInfoObject == null || markInfoObject.empty()) {
                return null;
            }
            COSBase markInfo = markInfoObject.getDirectBase();
            if (markInfo != null && markInfo.getType() == COSObjType.COS_DICT) {
                return markInfo.getBooleanKey(ASAtom.MARKED);
            }
            LOGGER.log(Level.WARNING, "MarkedInfo must be a 'COSDictionary' but got: " + markInfoObject.getType());
            return null;
        }
        return null;
    }

    public Boolean getDisplayDocTitle() {
        if (this.catalog != null) {
            COSObject viewerPrefObject = this.catalog.getKey(ASAtom.VIEWER_PREFERENCES);
            if (viewerPrefObject == null || viewerPrefObject.empty()) {
                return null;
            }
            COSBase viewerPref = viewerPrefObject.getDirectBase();
            if (viewerPref.getType() == COSObjType.COS_DICT) {
                return viewerPref.getBooleanKey(ASAtom.DISPLAY_DOC_TITLE);
            }
            LOGGER.log(Level.WARNING, "viewerPref must be a 'COSDictionary' but got: " + viewerPrefObject.getType());
            return null;
        }
        return null;
    }

    public Boolean getcontainsPieceInfo() {
        return this.catalog != null && this.catalog.knownKey(ASAtom.PIECE_INFO) != false;
    }

    public String getMarkInfo() {
        if (this.catalog != null) {
            COSObject markInfoObject = this.catalog.getKey(ASAtom.MARK_INFO);
            return markInfoObject != null ? markInfoObject.toString() : null;
        }
        return null;
    }

    public String getViewerPreferences() {
        if (this.catalog != null) {
            COSObject viewerPrefObject = this.catalog.getKey(ASAtom.VIEWER_PREFERENCES);
            return viewerPrefObject != null ? viewerPrefObject.toString() : null;
        }
        return null;
    }

    public Boolean getcontainsInfo() {
        COSObject info = this.cosDocument.getTrailer().getInfo();
        return info != null && !info.empty();
    }

    public Boolean getSuspects() {
        if (this.catalog != null) {
            COSObject markInfoObject = this.catalog.getKey(ASAtom.MARK_INFO);
            if (markInfoObject == null || markInfoObject.empty()) {
                return null;
            }
            COSBase markInfo = markInfoObject.getDirectBase();
            if (markInfo.getType() == COSObjType.COS_DICT) {
                return markInfo.getBooleanKey(ASAtom.SUSPECTS);
            }
            LOGGER.log(Level.WARNING, "MarkedInfo must be a 'COSDictionary' but got: " + markInfoObject.getType());
            return null;
        }
        return null;
    }

    public String getRequirements() {
        COSObject reqArrayObject;
        if (this.catalog != null && (reqArrayObject = this.catalog.getKey(ASAtom.REQUIREMENTS)) != null && !reqArrayObject.empty()) {
            COSBase reqArray = reqArrayObject.getDirectBase();
            if (reqArray.getType() == COSObjType.COS_ARRAY) {
                return GFCosDocument.getRequirementsString((COSArray)reqArray);
            }
            if (reqArray.getType() == COSObjType.COS_DICT) {
                return GFCosDocument.getRequirementsString((COSDictionary)reqArray);
            }
        }
        return null;
    }

    private static String getRequirementsString(COSArray reqArray) {
        StringBuilder result = new StringBuilder();
        for (COSObject element : reqArray) {
            COSBase base = element.getDirectBase();
            if (base.getType() != COSObjType.COS_DICT) continue;
            result.append(GFCosDocument.getRequirementsString((COSDictionary)base));
            result.append(' ');
        }
        return result.toString();
    }

    private static String getRequirementsString(COSDictionary reqDict) {
        return reqDict.getNameKeyStringValue(ASAtom.S);
    }

    public Boolean getNeedsRendering() {
        if (!this.catalog.knownKey(ASAtom.NEEDS_RENDERING).booleanValue()) {
            return Boolean.FALSE;
        }
        return this.catalog.getBooleanKey(ASAtom.NEEDS_RENDERING);
    }

    public Boolean getcontainsEmbeddedFiles() {
        COSObject names;
        if (this.catalog != null && (names = this.catalog.getKey(ASAtom.NAMES)).getType() == COSObjType.COS_DICT) {
            return names.knownKey(ASAtom.EMBEDDED_FILES);
        }
        return Boolean.FALSE;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "trailer": {
                return this.getTrailer();
            }
            case "indirectObjects": {
                return this.getIndirectObjects();
            }
            case "document": {
                return GFCosDocument.getDocument();
            }
            case "xref": {
                return this.getXRefs();
            }
            case "EmbeddedFiles": {
                return this.getEmbeddedFiles();
            }
            case "doc": {
                return this.getdocument();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosFileSpecification> getEmbeddedFiles() {
        PDNameTreeNode embeddedFiles;
        PDCatalog catalog;
        PDNamesDictionary namesDictionary;
        if (this.catalog != null && (namesDictionary = (catalog = StaticResources.getDocument().getCatalog()).getNamesDictionary()) != null && (embeddedFiles = namesDictionary.getEmbeddedFiles()) != null) {
            ArrayList<CosFileSpecification> files = new ArrayList<CosFileSpecification>();
            this.getNamesEmbeddedFiles(files, embeddedFiles);
            return Collections.unmodifiableList(files);
        }
        return Collections.emptyList();
    }

    private void getNamesEmbeddedFiles(List<CosFileSpecification> files, PDNameTreeNode node) {
        Map names = node.getNames();
        for (COSObject value : names.values()) {
            if (value == null || !value.getType().isDictionaryBased()) continue;
            files.add(new GFCosFileSpecification((COSDictionary)value.getDirectBase(), true));
        }
        for (PDNameTreeNode kid : node.getKids()) {
            this.getNamesEmbeddedFiles(files, kid);
        }
    }

    private List<CosTrailer> getTrailer() {
        ArrayList<GFCosTrailer> list = new ArrayList<GFCosTrailer>(1);
        list.add(new GFCosTrailer((COSDictionary)this.cosDocument.getTrailer().getObject().getDirectBase()));
        return Collections.unmodifiableList(list);
    }

    private List<CosIndirect> getIndirectObjects() {
        Map objects = this.cosDocument.getObjectsMap();
        ArrayList<GFCosIndirect> list = new ArrayList<GFCosIndirect>(objects.size());
        for (Map.Entry entry : objects.entrySet()) {
            list.add(new GFCosIndirect((COSKey)entry.getKey(), (COSObject)entry.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private static List<PDDocument> getDocument() {
        if (StaticResources.getDocument() != null) {
            ArrayList<GFPDDocument> list = new ArrayList<GFPDDocument>(1);
            list.add(new GFPDDocument(StaticResources.getDocument()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<SAPDFDocument> getdocument() {
        if (PDFFlavours.isWCAGFlavour((PDFAFlavour)StaticContainers.getFlavour()) && StaticResources.getDocument() != null && GFCosDocument.isPresent(GFSAPDFDOCUMENT_CLASS_NAME)) {
            ArrayList<GFSAPDFDocument> list = new ArrayList<GFSAPDFDocument>(1);
            org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers.setIsHuman((Boolean)PDFFlavours.isFlavourLevel(StaticContainers.getFlavours(), (PDFAFlavour.Level)PDFAFlavour.Level.HUMAN));
            list.add(new GFSAPDFDocument(StaticResources.getDocument()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private List<CosXRef> getXRefs() {
        ArrayList<GFCosXRef> list = new ArrayList<GFCosXRef>(1);
        list.add(new GFCosXRef(this.cosDocument.isSubsectionHeaderSpaceSeparated(), this.cosDocument.isXrefEOLMarkersComplyPDFA()));
        return Collections.unmodifiableList(list);
    }

    private COSDictionary getCatalog() {
        COSBase catalogLocal = this.cosDocument.getTrailer().getRoot().getDirectBase();
        if (catalogLocal != null && catalogLocal.getType() == COSObjType.COS_DICT) {
            return (COSDictionary)catalogLocal;
        }
        return null;
    }
}

