/**
 * This file is part of veraPDF Validation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.gf.model.impl.pd.gfse.contents;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.selayer.SEGroupedContent;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFConstants;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

import java.util.List;

public abstract class GFSEGroupedContent extends GFSEContentItem implements SEGroupedContent {
    
    List<Operator> operators;
    protected COSObject parentStructElem;
    protected String parentsTags;
    protected boolean isSignature;
    protected final String defaultLang;
    
    public GFSEGroupedContent(String objectType, COSObject parentStructElem, String parentsTags, String defaultLang, 
                              boolean isSignature) {
        super(objectType);
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
        this.defaultLang = defaultLang;
        this.isSignature = isSignature;
    }

    @Override
    public String getparentsTags() {
        return parentsTags;
    }

    @Override
    public String getparentStructureTag() {
        return parentStructElem != null ? parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    @Override
    public String getparentStandardTag() {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (parentStructElem != null && taggedPDFRoleMapHelper != null) {
            PDStructElem structElem = new PDStructElem(parentStructElem, taggedPDFRoleMapHelper.getRoleMap());
            return GFSEFactory.getStructureElementStandardType(structElem);
        }
        return null;
    }

    @Override
    public Boolean getisSignature() {
        return isSignature;
    }

    public String getLang() {
        return defaultLang;
    }

    @Override
    public Boolean getisArtifact() {
        return hasParentWithStandardType(TaggedPDFConstants.ARTIFACT);
    }

    protected Boolean hasParentWithStandardType(String standardType) {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (parentStructElem != null && taggedPDFRoleMapHelper != null) {
            PDStructElem structElem = new PDStructElem(parentStructElem, taggedPDFRoleMapHelper.getRoleMap());
            while (structElem != null) {
                if (standardType.equals(GFSEFactory.getStructureElementStandardType(structElem))) {
                    return true;
                }
                structElem = structElem.getParent();
            }
        }
        return false;
    }

    public String getInheritedActualText() {
        return null;
    }

    public String getInheritedAlt() {
        return null;
    }
    
    public Long getMCID() {
        return null;
    }

    @Override
    public String getActualText() {
        return null;
    }

    @Override
    public String getAlt() {
        return null;
    }
}
