/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse.contents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.operator.inlineimage.GFOp_EI;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_BDC;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOpPathPaint;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_n;
import org.verapdf.gf.model.impl.operator.shading.GFOp_sh;
import org.verapdf.gf.model.impl.operator.textshow.GFOpTextShow;
import org.verapdf.gf.model.impl.operator.xobject.GFOp_Do;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEContentItem;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEGroupedContent;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEImageXObjectItem;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEInlineImageItem;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSELineArtItem;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEShadingItem;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSETextItem;
import org.verapdf.gf.model.impl.pd.images.GFPDXImage;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.model.selayer.SEContentItem;
import org.verapdf.model.selayer.SEMarkedContent;

public class GFSEMarkedContent
extends GFSEGroupedContent
implements SEMarkedContent {
    public static final String MARKED_CONTENT_TYPE = "SEMarkedContent";
    public static final String LANG = "Lang";
    private final GFOpMarkedContent operator;

    public GFSEMarkedContent(List<Operator> operators, COSObject parentStructElem, String parentsTags, String defaultLang, boolean isSignature) {
        super(MARKED_CONTENT_TYPE, parentStructElem, parentsTags, defaultLang, isSignature);
        this.operators = operators.subList(1, operators.size() - 1);
        this.operator = (GFOpMarkedContent)operators.get(0);
        COSObject structElem = this.operator.getParentStructElem();
        if (structElem != null) {
            this.parentStructElem = structElem;
        }
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "contentItem": {
                return this.getContentItem();
            }
            case "Lang": {
                return this.getLinkLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SEContentItem> getContentItem() {
        if (this.operators == null) {
            return Collections.emptyList();
        }
        Stack<Integer> markedContentStack = new Stack<Integer>();
        ArrayList<GFSEContentItem> list = new ArrayList<GFSEContentItem>();
        for (int i = 0; i < this.operators.size(); ++i) {
            PDXObject xObject;
            Operator op = (Operator)this.operators.get(i);
            String type = op.getObjectType();
            if ("Op_BDC".equals(type) || "Op_BMC".equals(type)) {
                markedContentStack.push(i);
            } else if ("Op_EMC".equals(type) && !markedContentStack.empty()) {
                int markedContentIndex = (Integer)markedContentStack.pop();
                if (markedContentStack.empty()) {
                    list.add(new GFSEMarkedContent(this.operators.subList(markedContentIndex, i + 1), this.parentStructElem, this.parentsTags, this.defaultLang, this.isSignature));
                }
            }
            if (!markedContentStack.empty()) continue;
            if (op instanceof GFOpTextShow) {
                list.add(new GFSETextItem((GFOpTextShow)op, (GFSEGroupedContent)this));
                continue;
            }
            if (op instanceof GFOp_sh) {
                list.add(new GFSEShadingItem((GFOp_sh)op, (GFSEGroupedContent)this));
                continue;
            }
            if (op instanceof GFOpPathPaint && !(op instanceof GFOp_n)) {
                list.add(new GFSELineArtItem((GFOpPathPaint)op, (GFSEGroupedContent)this));
                continue;
            }
            if (op instanceof GFOp_EI) {
                list.add(new GFSEInlineImageItem((GFOp_EI)op, (GFSEGroupedContent)this));
                continue;
            }
            if (!(op instanceof GFOp_Do) || (xObject = ((GFOp_Do)op).getXObject()) == null || !ASAtom.IMAGE.getValue().equals(xObject.getSubtype())) continue;
            list.add(new GFSEImageXObjectItem((GFOp_Do)op, (GFPDXImage)xObject, this));
        }
        return Collections.unmodifiableList(list);
    }

    public List<CosLang> getLinkLang() {
        return this.operator.getLinkLang();
    }

    public String getinheritedLang() {
        String inheritedLang = this.operator.getParentLang();
        return inheritedLang != null ? inheritedLang : this.defaultLang;
    }

    public String getExtraContext() {
        Long mcid = this.operator.getInheritedMCID();
        return mcid != null ? "mcid:" + mcid : null;
    }

    public String gettag() {
        COSName tag = this.operator.getTag();
        return tag != null ? tag.getString() : null;
    }

    public String getstructureTag() {
        return this.parentStructElem != null ? this.parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getE() {
        COSString E = this.operator.getE();
        return E != null ? E.toString() : null;
    }

    @Override
    public String getAlt() {
        COSString Alt = this.operator.getAlt();
        return Alt != null ? Alt.toString() : null;
    }

    @Override
    public String getActualText() {
        COSString ActualText = this.operator.getActualText();
        return ActualText != null ? ActualText.toString() : null;
    }

    @Override
    public String getparentsTags() {
        return this.operator.getParentsTags();
    }

    @Override
    public String getLang() {
        String structParentLang;
        COSString lang = this.operator.getLang();
        if (lang != null) {
            return lang.getString();
        }
        if ("Op_BDC".equals(this.operator.getObjectType()) && (structParentLang = ((GFOp_BDC)this.operator).getstructParentLang()) != null) {
            return structParentLang;
        }
        String parentLang = this.operator.getParentLang();
        return parentLang != null ? parentLang : super.getLang();
    }

    @Override
    public String getInheritedActualText() {
        COSString actualText = this.operator.getInheritedActualText();
        if (actualText != null) {
            return actualText.getString();
        }
        return null;
    }

    @Override
    public String getInheritedAlt() {
        COSString alt = this.operator.getInheritedAlt();
        if (alt != null) {
            return alt.getString();
        }
        return null;
    }

    @Override
    public Long getMCID() {
        return this.operator.getMCID();
    }
}

