/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSName;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.cos.GFCosIIFilter;
import org.verapdf.gf.model.impl.cos.GFCosRenderingIntent;
import org.verapdf.gf.model.impl.pd.GFPDResource;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDInlineImage;
import org.verapdf.pd.PDResource;

public class GFPDInlineImage
extends GFPDResource
implements PDInlineImage {
    public static final String F = "F";
    public static final String INLINE_IMAGE_TYPE = "PDInlineImage";

    public GFPDInlineImage(org.verapdf.pd.images.PDInlineImage simplePDObject) {
        super((PDResource)simplePDObject, INLINE_IMAGE_TYPE);
    }

    public Boolean getInterpolate() {
        return ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).isInterpolate();
    }

    public String getSubtype() {
        return null;
    }

    @Override
    public Boolean getisInherited() {
        return ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).isInherited();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "SMask": 
            case "OPI": 
            case "Alternates": 
            case "jpxStream": {
                return Collections.emptyList();
            }
            case "F": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosIIFilter> getFilters() {
        List filters = ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getCOSFilters();
        if (!filters.isEmpty()) {
            ArrayList<GFCosIIFilter> result = new ArrayList<GFCosIIFilter>(filters.size());
            for (COSName filter : filters) {
                result.add(new GFCosIIFilter(filter));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<PDColorSpace> getImageCS() {
        PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getImageCS());
        if (buffer != null) {
            ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
            colorSpaces.add(buffer);
            return Collections.unmodifiableList(colorSpaces);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getIntent() {
        COSName intent = ((org.verapdf.pd.images.PDInlineImage)this.simplePDObject).getIntent();
        if (intent != null) {
            ArrayList<GFCosRenderingIntent> intents = new ArrayList<GFCosRenderingIntent>(1);
            intents.add(new GFCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }
}

