/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDGroup;
import org.verapdf.gf.model.impl.pd.GFPDSemanticContentStream;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDXForm;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDXForm
extends GFPDXObject
implements PDXForm {
    public static final String X_FORM_TYPE = "PDXForm";
    public static final String GROUP = "Group";
    public static final String CONTENT_STREAM = "contentStream";
    private List<PDContentStream> contentStreams = null;
    private List<org.verapdf.model.pdlayer.PDGroup> groups = null;
    private boolean groupContainsTransparency = false;
    private boolean contentStreamContainsTransparency = false;
    private final GraphicState inheritedGraphicState;
    private final String parentStructureTag;
    private final String parentsTags;

    public GFPDXForm(org.verapdf.pd.images.PDXForm simplePDObject, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState, String parentStructureTag, String parentsTags) {
        super((PDXObject)simplePDObject, resourcesHandler.getExtendedResources(simplePDObject.getResources()), X_FORM_TYPE);
        this.inheritedGraphicState = inheritedGraphicState;
        this.parentStructureTag = parentStructureTag;
        this.parentsTags = parentsTags;
    }

    public String getSubtype2() {
        ASAtom subtype2 = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getSubtype2();
        return subtype2 == null ? null : subtype2.getValue();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "contentStream": {
                return this.getContentStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDGroup> getGroup() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        return this.groups;
    }

    public Boolean getcontainsPS() {
        return this.simplePDObject.knownKey(ASAtom.PS);
    }

    public Boolean getcontainsRef() {
        return this.simplePDObject.knownKey(ASAtom.REF);
    }

    public Boolean getisUniqueSemanticParent() {
        if (!this.simplePDObject.knownKey(ASAtom.STRUCT_PARENTS)) {
            return true;
        }
        COSKey key = this.simplePDObject.getObject().getKey();
        if (key == null) {
            return true;
        }
        if (StaticContainers.getXFormKeysSet().contains(key)) {
            return false;
        }
        StaticContainers.getXFormKeysSet().add(key);
        return true;
    }

    @Override
    public String getID() {
        return null;
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void initializeGroups() {
        org.verapdf.pd.images.PDXForm form = (org.verapdf.pd.images.PDXForm)this.simplePDObject;
        PDGroup group = form.getGroup();
        if (group != null) {
            this.groupContainsTransparency = ASAtom.TRANSPARENCY.equals((Object)group.getSubtype());
            ArrayList<GFPDGroup> groups = new ArrayList<GFPDGroup>(1);
            groups.add(new GFPDGroup(group, this.resourcesHandler.getObjectResources()));
            this.groups = Collections.unmodifiableList(groups);
        } else {
            this.groups = Collections.emptyList();
        }
    }

    private void parseContentStream() {
        ArrayList<PDContentStream> streams = new ArrayList<PDContentStream>(1);
        GFPDContentStream gfContentStream = !PDFAFlavour.PDFUA_1.getPart().getFamily().equals(StaticContainers.getFlavour().getPart().getFamily()) ? new GFPDContentStream((org.verapdf.pd.PDContentStream)((org.verapdf.pd.images.PDXForm)this.simplePDObject), this.resourcesHandler, this.inheritedGraphicState, new StructureElementAccessObject(this.simpleCOSObject), this.parentStructureTag, this.parentsTags) : new GFPDSemanticContentStream((org.verapdf.pd.PDContentStream)((org.verapdf.pd.images.PDXForm)this.simplePDObject), this.resourcesHandler, this.inheritedGraphicState, new StructureElementAccessObject(this.simpleCOSObject), this.parentStructureTag, this.parentsTags);
        this.contentStreamContainsTransparency = gfContentStream.isContainsTransparency();
        streams.add(gfContentStream);
        this.contentStreams = streams;
    }

    public boolean containsTransparency() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.groupContainsTransparency || this.contentStreamContainsTransparency;
    }
}

