/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.cos.GFCosArray;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.impl.cos.GFCosStream;
import org.verapdf.gf.model.impl.pd.GFPDFormField;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;
import org.verapdf.pd.PDObject;

public class GFPDAcroForm
extends GFPDObject
implements PDAcroForm {
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";
    public static final String XFA = "XFA";

    public GFPDAcroForm(org.verapdf.pd.form.PDAcroForm acroForm) {
        super((PDObject)acroForm, ACRO_FORM_TYPE);
    }

    public Boolean getNeedAppearances() {
        return ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getNeedAppearances();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
            case "XFA": {
                return this.getXFA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List fields = ((org.verapdf.pd.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<GFPDFormField> formFields = new ArrayList<GFPDFormField>(1);
        for (org.verapdf.pd.form.PDFormField field : fields) {
            formFields.add(GFPDFormField.createTypedFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }

    private List<CosObject> getXFA() {
        org.verapdf.pd.form.PDAcroForm form = (org.verapdf.pd.form.PDAcroForm)this.simplePDObject;
        COSObject value = form.getKey(ASAtom.XFA);
        if (value != null) {
            boolean isStream;
            boolean bl = isStream = value.getType() == COSObjType.COS_STREAM;
            if (isStream || value.getType() == COSObjType.COS_ARRAY) {
                ArrayList<GFCosObject> list = new ArrayList<GFCosObject>(1);
                if (isStream) {
                    list.add(new GFCosStream((COSStream)value.getDirectBase()));
                } else {
                    list.add(new GFCosArray((COSArray)value.getDirectBase()));
                }
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }
}

