/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse;

import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.pd.gfse.GFSEFactory;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.selayer.SEContentItem;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public abstract class GFSEContentItem
extends GenericModelObject
implements SEContentItem {
    public static final String CONTENT_ITEM = "contentItem";
    protected Long parentMCID;
    protected GFOpMarkedContent parentMarkedContentOperator;
    List<Operator> operators;
    protected COSObject parentStructElem;
    protected String parentsTags;

    public GFSEContentItem(String objectType, COSObject parentStructElem, String parentsTags) {
        super(objectType);
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
    }

    public GFSEContentItem(String objectType, GFOpMarkedContent parentMarkedContentOperator, COSObject parentStructElem, String parentsTags) {
        super(objectType);
        this.parentMarkedContentOperator = parentMarkedContentOperator;
        this.parentMCID = parentMarkedContentOperator != null ? parentMarkedContentOperator.getMCID() : null;
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
    }

    public String getExtraContext() {
        return this.parentMCID != null ? "mcid:" + this.parentMCID : null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "contentItem": {
                return Collections.emptyList();
            }
        }
        return super.getLinkedObjects(link);
    }

    public String getparentsTags() {
        if (this.parentMarkedContentOperator != null) {
            return this.parentMarkedContentOperator.getParentsTags();
        }
        return this.parentsTags;
    }

    public String getparentStructureTag() {
        return this.parentStructElem != null ? this.parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getparentStandardTag() {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            PDStructElem structElem = new PDStructElem(this.parentStructElem, taggedPDFRoleMapHelper.getRoleMap());
            return GFSEFactory.getStructureElementStandardType(structElem);
        }
        return null;
    }

    public String getActualText() {
        return null;
    }

    public Boolean getisArtifact() {
        return this.hasParentWithStandardType("Artifact");
    }

    protected Boolean hasParentWithStandardType(String standardType) {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            for (PDStructElem structElem = new PDStructElem(this.parentStructElem, taggedPDFRoleMapHelper.getRoleMap()); structElem != null; structElem = structElem.getParent()) {
                if (!standardType.equals(GFSEFactory.getStructureElementStandardType(structElem))) continue;
                return true;
            }
        }
        return false;
    }
}

